/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import org.w3c.dom.Document;

public class DosLineEndingDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("MangledCRLF", "Mangled file line endings", "On Windows, line endings are typically recorded as carriage return plus newline: \\r\\n.\n\nThis detector looks for invalid line endings with repeated carriage return characters (without newlines). Previous versions of the ADT plugin could accidentally introduce these into the file, and when editing the file, the editor could produce confusing visual artifacts.", Category.CORRECTNESS, 2, Severity.ERROR, new Implementation(DosLineEndingDetector.class, Scope.RESOURCE_FILE_SCOPE)).setEnabledByDefault(false).addMoreInfo("https://bugs.eclipse.org/bugs/show_bug.cgi?id=375421");

    @Override
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public void visitDocument(XmlContext context, Document document) {
        String contents = context.getContents();
        if (contents == null) {
            return;
        }
        char prev = '\u0000';
        int n = contents.length();
        for (int i = 0; i < n; ++i) {
            char c = contents.charAt(i);
            if (c == '\r' && prev == '\r') {
                String message = "Incorrect line ending: found carriage return (`\\r`) without corresponding newline (`\\n`)";
                boolean blankLine = true;
                for (int index = i - 2; index < i; ++index) {
                    char d = contents.charAt(index);
                    if (Character.isWhitespace(d)) continue;
                    blankLine = false;
                }
                int lineBegin = i;
                for (int index = i - 2; index >= 0; --index) {
                    char d = contents.charAt(index);
                    if (d == '\n') {
                        lineBegin = index + 1;
                        if (blankLine) continue;
                        break;
                    }
                    if (Character.isWhitespace(d)) continue;
                    blankLine = false;
                }
                int lineEnd = Math.min(contents.length(), i + 1);
                Location location = Location.create(context.file, contents, lineBegin, lineEnd);
                context.report(ISSUE, document.getDocumentElement(), location, message);
                return;
            }
            prev = c;
        }
    }
}

