/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CipherGetInstanceDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("GetInstance", "Cipher.getInstance with ECB", "`Cipher#getInstance` should not be called with ECB as the cipher mode or without setting the cipher mode because the default mode on android is ECB, which is insecure.", Category.SECURITY, 9, Severity.WARNING, new Implementation(CipherGetInstanceDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    private static final Set<String> ALGORITHM_ONLY = Sets.newHashSet((Object[])new String[]{"AES", "DES", "DESede"});
    private static final String ECB = "ECB";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_INSTANCE);
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        PsiExpression expression;
        Object value;
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, CIPHER, false)) {
            return;
        }
        PsiExpressionList argumentList = node.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 1 && (value = ConstantEvaluator.evaluate(context, (PsiElement)(expression = arguments[0]))) instanceof String) {
            CipherGetInstanceDetector.checkParameter(context, node, (PsiElement)expression, (String)value, !(expression instanceof PsiLiteral));
        }
    }

    private static void checkParameter(JavaContext context, PsiMethodCallExpression call, PsiElement node, String value, boolean includeValue) {
        if (ALGORITHM_ONLY.contains(value)) {
            String message = "`Cipher.getInstance` should not be called without setting the encryption mode and padding";
            context.report(ISSUE, (PsiElement)call, context.getLocation(node), message);
        } else if (value.contains(ECB)) {
            String message = "ECB encryption mode should not be used";
            if (includeValue) {
                message = message + " (was \"" + value + "\")";
            }
            context.report(ISSUE, (PsiElement)call, context.getLocation(node), message);
        }
    }
}

