/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class AnnotationDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INSIDE_METHOD = Issue.create("LocalSuppress", "@SuppressLint on invalid element", "The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    public static final Issue ANNOTATION_USAGE = Issue.create("SupportAnnotationUsage", "Incorrect support annotation usage", "This lint check makes sure that the support annotations (such as `@IntDef` and `@ColorInt`) are used correctly. For example, it's an error to specify an `@IntRange` where the `from` value is higher than the `to` value.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
    public static final Issue UNIQUE = Issue.create("UniqueConstants", "Overlapping Enumeration Constants", "The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. However, it's possible to accidentally specify the same value for two or more of the values, which can lead to hard-to-detect bugs. This check looks for this scenario and flags any repeated constants.\n\nIn some cases, the repeated constant is intentional (for example, renaming a constant to a more intuitive name, and leaving the old name in place for compatibility purposes.)  In that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` annotation.", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    public static final Issue FLAG_STYLE = Issue.create("ShiftFlags", "Dangerous Flag Constant Declaration", "When defining multiple constants for use in flags, the recommended style is to use the form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and non-overlapping.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    public static final Issue SWITCH_TYPE_DEF = Issue.create("SwitchIntDef", "Missing @IntDef in Switch", "This check warns if a `switch` statement does not explicitly include all the values declared by the typedef `@IntDef` declaration.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    private Set<PsiElement> mWarnedFlags;

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        ArrayList<Class<? extends PsiElement>> types = new ArrayList<Class<? extends PsiElement>>(2);
        types.add(PsiAnnotation.class);
        types.add(PsiSwitchStatement.class);
        return types;
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new AnnotationChecker(context);
    }

    private static List<String> computeFieldNames(PsiSwitchStatement node, Iterable<?> allowedValues) {
        ArrayList list = Lists.newArrayList();
        for (Object o : allowedValues) {
            PsiClass containingClass;
            if (o instanceof PsiReferenceExpression) {
                PsiElement resolved = ((PsiReferenceExpression)o).resolve();
                if (resolved != null) {
                    o = resolved;
                }
            } else if (o instanceof PsiLiteral) {
                list.add("`" + ((PsiLiteral)o).getValue() + '`');
                continue;
            }
            if (!(o instanceof PsiField)) continue;
            PsiField field = (PsiField)o;
            String name = field.getName();
            PsiClass clz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)node, PsiClass.class, (boolean)true);
            if (clz != null && (containingClass = field.getContainingClass()) != null && !containingClass.equals(clz)) {
                name = containingClass.getName() + '.' + field.getName();
            }
            list.add('`' + name + '`');
        }
        Collections.sort(list);
        return list;
    }

    public static List<String> getMissingCases(String errorMessage, TextFormat format) {
        String substring = LintUtils.findSubstring(errorMessage = format.toText(errorMessage), " missing case ", null);
        if (substring == null) {
            substring = LintUtils.findSubstring(errorMessage, "expected one of: ", null);
        }
        if (substring != null) {
            return Splitter.on((String)",").trimResults().splitToList((CharSequence)substring);
        }
        return null;
    }

    private static PsiElement getAnnotationScope(PsiAnnotation node) {
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)node, PsiAnnotation.class, (boolean)true);
        if (scope == null) {
            scope = node;
        }
        return scope;
    }

    private class AnnotationChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            block15: {
                PsiClass cls;
                PsiElement resolved;
                String type;
                block17: {
                    block25: {
                        int set;
                        block26: {
                            block24: {
                                block23: {
                                    block20: {
                                        long min;
                                        long exact;
                                        int unset;
                                        block22: {
                                            long multiple;
                                            block21: {
                                                block19: {
                                                    boolean invalid;
                                                    block18: {
                                                        PsiMethod method;
                                                        block14: {
                                                            PsiAnnotationMemberValue value;
                                                            block16: {
                                                                type = annotation.getQualifiedName();
                                                                if (type == null || type.startsWith("java.lang.")) {
                                                                    return;
                                                                }
                                                                if (!"android.annotation.SuppressLint".equals(type)) break block14;
                                                                PsiAnnotationOwner owner = annotation.getOwner();
                                                                if (owner == null) {
                                                                    return;
                                                                }
                                                                if (owner instanceof PsiModifierList) {
                                                                    PsiElement parent = ((PsiModifierList)owner).getParent();
                                                                    if (!(parent instanceof PsiDeclarationStatement || parent instanceof PsiLocalVariable || parent instanceof PsiParameter)) {
                                                                        return;
                                                                    }
                                                                } else {
                                                                    return;
                                                                }
                                                                PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                                                                if (attributes.length != 1) break block15;
                                                                PsiNameValuePair attribute = attributes[0];
                                                                value = attribute.getValue();
                                                                if (!(value instanceof PsiLiteral)) break block16;
                                                                Object v = ((PsiLiteral)value).getValue();
                                                                if (!(v instanceof String)) break block15;
                                                                String id = (String)v;
                                                                this.checkSuppressLint(annotation, id);
                                                                break block15;
                                                            }
                                                            if (!(value instanceof PsiArrayInitializerMemberValue)) break block15;
                                                            PsiArrayInitializerMemberValue initializer = (PsiArrayInitializerMemberValue)value;
                                                            for (PsiAnnotationMemberValue expression : initializer.getInitializers()) {
                                                                String id;
                                                                Object v;
                                                                if (!(expression instanceof PsiLiteral) || !((v = ((PsiLiteral)expression).getValue()) instanceof String) || this.checkSuppressLint(annotation, id = (String)v)) continue;
                                                                return;
                                                            }
                                                            break block15;
                                                        }
                                                        if (!type.startsWith("android.support.annotation.")) break block17;
                                                        if (!"android.support.annotation.CheckResult".equals(type)) break block18;
                                                        if (!(annotation.getParent() instanceof PsiModifierList) || !(annotation.getParent().getParent() instanceof PsiMethod) || (method = (PsiMethod)annotation.getParent().getParent()).isConstructor() || !PsiType.VOID.equals((Object)method.getReturnType())) break block15;
                                                        this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "@CheckResult should not be specified on `void` methods");
                                                        break block15;
                                                    }
                                                    if (!"android.support.annotation.IntRange".equals(type) && !"android.support.annotation.FloatRange".equals(type)) break block19;
                                                    if ("android.support.annotation.IntRange".equals(type)) {
                                                        this.checkTargetType(annotation, "int", "long", true);
                                                        long from = SupportAnnotationDetector.getLongAttribute(annotation, "from", Long.MIN_VALUE);
                                                        long to = SupportAnnotationDetector.getLongAttribute(annotation, "to", Long.MAX_VALUE);
                                                        invalid = from > to;
                                                    } else {
                                                        this.checkTargetType(annotation, "float", "double", true);
                                                        double from = SupportAnnotationDetector.getDoubleAttribute(annotation, "from", Double.NEGATIVE_INFINITY);
                                                        double to = SupportAnnotationDetector.getDoubleAttribute(annotation, "to", Double.POSITIVE_INFINITY);
                                                        boolean bl = invalid = from > to;
                                                    }
                                                    if (!invalid) break block15;
                                                    this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "Invalid range: the `from` attribute must be less than the `to` attribute");
                                                    break block15;
                                                }
                                                if (!"android.support.annotation.Size".equals(type)) break block20;
                                                unset = -42;
                                                exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", unset);
                                                min = SupportAnnotationDetector.getLongAttribute(annotation, "min", Long.MIN_VALUE);
                                                long max = SupportAnnotationDetector.getLongAttribute(annotation, "max", Long.MAX_VALUE);
                                                multiple = SupportAnnotationDetector.getLongAttribute(annotation, "multiple", 1L);
                                                if (min <= max) break block21;
                                                this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "Invalid size range: the `min` attribute must be less than the `max` attribute");
                                                break block15;
                                            }
                                            if (multiple >= 1L) break block22;
                                            this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "The size multiple must be at least 1");
                                            break block15;
                                        }
                                        if ((exact >= 0L || exact == (long)unset) && (min >= 0L || min == Long.MIN_VALUE)) break block15;
                                        this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "The size can't be negative");
                                        break block15;
                                    }
                                    if (!"android.support.annotation.ColorInt".equals(type) && !"android.support.annotation.Px".equals(type)) break block23;
                                    this.checkTargetType(annotation, "int", "long", true);
                                    break block15;
                                }
                                if (!"android.support.annotation.IntDef".equals(type)) break block24;
                                this.ensureUniqueValues(annotation);
                                break block15;
                            }
                            if (!"android.support.annotation.RequiresPermission".equals(type) && !"android.support.annotation.RequiresPermission.Read".equals(type) && !"android.support.annotation.RequiresPermission.Write".equals(type)) break block25;
                            if (!(annotation.getParent() instanceof PsiModifierList) || !(annotation.getParent().getParent() instanceof PsiMethod)) break block15;
                            String value = PermissionRequirement.getAnnotationStringValue(annotation, "value");
                            String[] anyOf = PermissionRequirement.getAnnotationStringValues(annotation, "anyOf");
                            String[] allOf = PermissionRequirement.getAnnotationStringValues(annotation, "allOf");
                            set = 0;
                            if (value != null) {
                                ++set;
                            }
                            if (allOf != null) {
                                ++set;
                            }
                            if (anyOf != null) {
                                ++set;
                            }
                            if (set != 0) break block26;
                            this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "For methods, permission annotation should specify one of `value`, `anyOf` or `allOf`");
                            break block15;
                        }
                        if (set <= 1) break block15;
                        this.mContext.report(ANNOTATION_USAGE, (PsiElement)annotation, this.mContext.getLocation((PsiElement)annotation), "Only specify one of `value`, `anyOf` or `allOf`");
                        break block15;
                    }
                    if (!type.endsWith("Res")) break block15;
                    this.checkTargetType(annotation, "int", "long", true);
                    break block15;
                }
                PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
                if (referenceElement != null && (resolved = referenceElement.resolve()) instanceof PsiClass && (cls = (PsiClass)resolved).isAnnotationType() && cls.getModifierList() != null) {
                    for (PsiAnnotation a : cls.getModifierList().getAnnotations()) {
                        String name = a.getQualifiedName();
                        if ("android.support.annotation.IntDef".equals(name)) {
                            this.checkTargetType(annotation, "int", "long", true);
                            continue;
                        }
                        if (!"android.support.annotation.StringDef".equals(type)) continue;
                        this.checkTargetType(annotation, "java.lang.String", null, true);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkTargetType(PsiAnnotation node, String type1, String type2, boolean allowCollection) {
            String expectedTypes;
            String typeName;
            PsiType type;
            PsiAnnotationOwner owner = node.getOwner();
            if (!(owner instanceof PsiModifierList)) return;
            PsiElement parent = ((PsiModifierList)owner).getParent();
            if (parent instanceof PsiDeclarationStatement) {
                PsiElement[] elements = ((PsiDeclarationStatement)parent).getDeclaredElements();
                if (elements.length <= 0) return;
                PsiElement element = elements[0];
                if (!(element instanceof PsiLocalVariable)) return;
                type = ((PsiLocalVariable)element).getType();
            } else if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                type = method.isConstructor() ? this.mContext.getEvaluator().getClassType(method.getContainingClass()) : method.getReturnType();
            } else {
                if (!(parent instanceof PsiVariable)) return;
                type = ((PsiVariable)parent).getType();
            }
            if (type == null) {
                return;
            }
            if (allowCollection) {
                PsiClass resolved;
                PsiClassType classType;
                if (type instanceof PsiArrayType) {
                    type = type.getDeepComponentType();
                } else if (type instanceof PsiClassType && (classType = (PsiClassType)type).getParameters().length == 1 && (resolved = classType.resolve()) != null && this.mContext.getEvaluator().implementsInterface(resolved, "java.util.Collection", false)) {
                    type = classType.getParameters()[0];
                }
            }
            if ((typeName = type.getCanonicalText()).equals(type1) || type2 != null && typeName.equals(type2)) return;
            if (typeName.equals(LintUtils.getAutoBoxedType(type1)) || type2 != null && typeName.equals(LintUtils.getAutoBoxedType(type2))) {
                return;
            }
            String string = expectedTypes = type2 == null ? type1 : type1 + " or " + type2;
            if (typeName.equals("java.lang.String")) {
                typeName = "String";
            }
            String message = String.format("This annotation does not apply for type %1$s; expected %2$s", typeName, expectedTypes);
            Location location = this.mContext.getLocation((PsiElement)node);
            this.mContext.report(ANNOTATION_USAGE, (PsiElement)node, location, message);
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            PsiAnnotation annotation;
            PsiExpression condition = statement.getExpression();
            if (condition != null && PsiType.INT.equals((Object)condition.getType()) && (annotation = this.findIntDef((PsiElement)condition)) != null) {
                this.checkSwitch(statement, annotation);
            }
        }

        private PsiAnnotation findIntDef(PsiElement node) {
            PsiParenthesizedExpression expression;
            if (node instanceof PsiReferenceExpression) {
                PsiElement resolved = ((PsiReference)node).resolve();
                if (resolved instanceof PsiModifierListOwner) {
                    PsiAnnotation[] annotations = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)resolved, true);
                    PsiAnnotation annotation = SupportAnnotationDetector.findIntDef(SupportAnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations));
                    if (annotation != null) {
                        return annotation;
                    }
                }
                if (resolved instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)resolved;
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
                    if (statement != null) {
                        PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                        String targetName = variable.getName();
                        if (targetName == null) {
                            return null;
                        }
                        while (prev != null) {
                            PsiReferenceExpression reference;
                            PsiAssignmentExpression assign;
                            PsiExpression lhs;
                            PsiExpression expression2;
                            if (prev instanceof PsiDeclarationStatement) {
                                for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                    if (!variable.equals(element)) continue;
                                    PsiExpression initializer = variable.getInitializer();
                                    if (initializer != null) {
                                        return this.findIntDef((PsiElement)initializer);
                                    }
                                    break;
                                }
                            } else if (prev instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression2).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                                PsiExpression rExpression = assign.getRExpression();
                                if (rExpression != null) {
                                    return this.findIntDef((PsiElement)rExpression);
                                }
                                break;
                            }
                            prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                        }
                    }
                }
            } else if (node instanceof PsiMethodCallExpression) {
                PsiAnnotation[] annotations;
                JavaEvaluator evaluator;
                PsiAnnotation annotation;
                PsiMethod method = ((PsiMethodCallExpression)node).resolveMethod();
                if (method != null && (annotation = SupportAnnotationDetector.findIntDef(SupportAnnotationDetector.filterRelevantAnnotations(evaluator = this.mContext.getEvaluator(), annotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, true)))) != null) {
                    return annotation;
                }
            } else if (node instanceof PsiConditionalExpression) {
                PsiAnnotation result;
                PsiConditionalExpression expression3 = (PsiConditionalExpression)node;
                if (expression3.getThenExpression() != null && (result = this.findIntDef((PsiElement)expression3.getThenExpression())) != null) {
                    return result;
                }
                if (expression3.getElseExpression() != null && (result = this.findIntDef((PsiElement)expression3.getElseExpression())) != null) {
                    return result;
                }
            } else if (node instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                if (cast.getOperand() != null) {
                    return this.findIntDef((PsiElement)cast.getOperand());
                }
            } else if (node instanceof PsiParenthesizedExpression && (expression = (PsiParenthesizedExpression)node).getExpression() != null) {
                return this.findIntDef((PsiElement)expression.getExpression());
            }
            return null;
        }

        private void checkSwitch(PsiSwitchStatement node, PsiAnnotation annotation) {
            PsiCodeBlock block = node.getBody();
            if (block == null) {
                return;
            }
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("value");
            if (value == null) {
                value = annotation.findDeclaredAttributeValue(null);
            }
            if (value == null) {
                return;
            }
            if (!(value instanceof PsiArrayInitializerMemberValue)) {
                return;
            }
            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value;
            PsiAnnotationMemberValue[] allowedValues = array.getInitializers();
            ArrayList fields = Lists.newArrayListWithCapacity((int)allowedValues.length);
            ArrayList seenValues = Lists.newArrayListWithCapacity((int)allowedValues.length);
            for (PsiAnnotationMemberValue psiAnnotationMemberValue : allowedValues) {
                if (psiAnnotationMemberValue instanceof PsiReferenceExpression) {
                    PsiElement resolved = ((PsiReferenceExpression)psiAnnotationMemberValue).resolve();
                    if (resolved == null) continue;
                    fields.add(resolved);
                    continue;
                }
                if (!(psiAnnotationMemberValue instanceof PsiLiteral)) continue;
                fields.add(psiAnnotationMemberValue);
            }
            for (PsiAnnotationMemberValue psiAnnotationMemberValue : block.getStatements()) {
                PsiExpression initializer;
                if (!(psiAnnotationMemberValue instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement caseStatement = (PsiSwitchLabelStatement)psiAnnotationMemberValue;
                PsiExpression expression = caseStatement.getCaseValue();
                if (expression instanceof PsiLiteral) {
                    List list = AnnotationDetector.computeFieldNames(node, Arrays.asList(allowedValues));
                    String message = "Don't use a constant here; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                    this.mContext.report(SWITCH_TYPE_DEF, (PsiElement)expression, this.mContext.getLocation((PsiElement)expression), message);
                    return;
                }
                if (!(expression instanceof PsiReferenceExpression)) continue;
                PsiElement resolved = ((PsiReferenceExpression)expression).resolve();
                if (resolved == null) {
                    return;
                }
                if (!(resolved instanceof PsiField)) continue;
                boolean found = false;
                ListIterator iterator = fields.listIterator();
                while (iterator.hasNext()) {
                    PsiElement field = (PsiElement)iterator.next();
                    if (!field.equals(resolved)) continue;
                    iterator.remove();
                    found = true;
                    break;
                }
                if (!found && (initializer = ((PsiField)resolved).getInitializer()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expression).resolve()) instanceof PsiField) {
                    iterator = fields.listIterator();
                    while (iterator.hasNext()) {
                        PsiElement field = (PsiElement)iterator.next();
                        if (!field.equals(initializer)) continue;
                        iterator.remove();
                        found = true;
                        break;
                    }
                }
                if (found) {
                    Integer cv = this.getConstantValue((PsiField)resolved);
                    if (cv == null) continue;
                    seenValues.add(cv);
                    continue;
                }
                List list = AnnotationDetector.computeFieldNames(node, Arrays.asList(allowedValues));
                String message = "Unexpected constant; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                Location location = this.mContext.getNameLocation((PsiElement)expression);
                this.mContext.report(SWITCH_TYPE_DEF, (PsiElement)expression, location, message);
            }
            if (!fields.isEmpty()) {
                ListIterator iterator = fields.listIterator();
                while (iterator.hasNext()) {
                    Integer cv;
                    PsiElement next = (PsiElement)iterator.next();
                    if (!(next instanceof PsiField) || !seenValues.contains(cv = this.getConstantValue((PsiField)next))) continue;
                    iterator.remove();
                }
            }
            if (!fields.isEmpty()) {
                List list = AnnotationDetector.computeFieldNames(node, fields);
                String message = "Switch statement on an `int` with known associated constant missing case " + Joiner.on((String)", ").join((Iterable)list);
                Location location = this.mContext.getNameLocation((PsiElement)node);
                this.mContext.report(SWITCH_TYPE_DEF, (PsiElement)node, location, message);
            }
        }

        private Integer getConstantValue(PsiField intDefConstantRef) {
            Object constant = intDefConstantRef.computeConstantValue();
            if (constant instanceof Number) {
                return ((Number)constant).intValue();
            }
            return null;
        }

        private void ensureUniqueValues(PsiAnnotation node) {
            boolean flag;
            PsiAnnotationMemberValue value = node.findAttributeValue("value");
            if (value == null) {
                value = node.findAttributeValue(null);
            }
            if (value == null) {
                return;
            }
            if (!(value instanceof PsiArrayInitializerMemberValue)) {
                return;
            }
            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value;
            PsiAnnotationMemberValue[] initializers = array.getInitializers();
            HashMap valueToIndex = Maps.newHashMapWithExpectedSize((int)initializers.length);
            boolean bl = flag = PermissionRequirement.getAnnotationBooleanValue(node, "flag") == Boolean.TRUE;
            if (flag) {
                this.ensureUsingFlagStyle(initializers);
            }
            ConstantEvaluator constantEvaluator = new ConstantEvaluator(this.mContext);
            for (int index = 0; index < initializers.length; ++index) {
                PsiAnnotationMemberValue expression = initializers[index];
                Object o = constantEvaluator.evaluate((PsiElement)expression);
                if (!(o instanceof Number)) continue;
                Number number = (Number)o;
                if (valueToIndex.containsKey(number)) {
                    Number repeatedValue = number;
                    int prevIndex = (Integer)valueToIndex.get(number);
                    PsiAnnotationMemberValue prevConstant = initializers[prevIndex];
                    String message = String.format("Constants `%1$s` and `%2$s` specify the same exact value (%3$s); this is usually a cut & paste or merge error", expression.getText(), prevConstant.getText(), repeatedValue.toString());
                    Location location = this.mContext.getLocation((PsiElement)expression);
                    Location secondary = this.mContext.getLocation((PsiElement)prevConstant);
                    secondary.setMessage("Previous same value");
                    location.setSecondary(secondary);
                    PsiElement scope = AnnotationDetector.getAnnotationScope(node);
                    this.mContext.report(UNIQUE, scope, location, message);
                    break;
                }
                valueToIndex.put(number, index);
            }
        }

        private void ensureUsingFlagStyle(PsiAnnotationMemberValue[] constants) {
            if (constants.length < 3) {
                return;
            }
            for (PsiAnnotationMemberValue constant : constants) {
                long value;
                PsiLiteral literal;
                Object o;
                PsiExpression initializer;
                PsiElement resolved;
                if (!(constant instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)constant).resolve()) instanceof PsiField) || !((initializer = ((PsiField)resolved).getInitializer()) instanceof PsiLiteral) || !((o = (literal = (PsiLiteral)initializer).getValue()) instanceof Number) || Math.abs(value = ((Number)o).longValue()) <= 1L || Long.bitCount(value) != 1) continue;
                int shift = Long.numberOfTrailingZeros(value);
                if (AnnotationDetector.this.mWarnedFlags == null) {
                    AnnotationDetector.this.mWarnedFlags = Sets.newHashSet();
                }
                if (!AnnotationDetector.this.mWarnedFlags.add(resolved)) {
                    return;
                }
                String message = String.format("Consider declaring this constant using 1 << %1$d instead", shift);
                Location location = this.mContext.getLocation((PsiElement)initializer);
                this.mContext.report(FLAG_STYLE, (PsiElement)initializer, location, message);
            }
        }

        private boolean checkSuppressLint(PsiAnnotation node, String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains((Object)Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                PsiElement scope = AnnotationDetector.getAnnotationScope(node);
                this.mContext.report(INSIDE_METHOD, scope, this.mContext.getLocation((PsiElement)node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }
    }
}

