/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassHolder<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myClassName;
    @Nullable
    private transient Class<T> myTargetClass;

    public ClassHolder(@NotNull Class<T> targetClass) {
        this.myTargetClass = targetClass;
        this.myClassName = this.myTargetClass.getName();
    }

    @NotNull
    public static <T> ClassHolder<T> from(@NotNull Class<T> clazz) {
        return new ClassHolder<T>(clazz);
    }

    @NotNull
    public Class<T> getTargetClass() throws ClassNotFoundException {
        if (this.myTargetClass == null) {
            this.myTargetClass = Class.forName(this.myClassName);
        }
        return this.myTargetClass;
    }

    @NotNull
    public String getTargetClassName() {
        return this.myClassName;
    }

    public int hashCode() {
        return this.myClassName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassHolder holder = (ClassHolder)o;
        if (!this.myClassName.equals(holder.myClassName)) {
            return false;
        }
        return !(this.myTargetClass != null ? !this.myTargetClass.equals(holder.myTargetClass) : holder.myTargetClass != null);
    }

    public String toString() {
        return this.myClassName;
    }
}

