/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupportedImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.task.AbstractExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.UnsupportedCancellationToken;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTaskManager
extends AbstractExternalSystemTaskManager<GradleExecutionSettings>
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = ContainerUtil.newConcurrentMap();

    public void executeTasks(final @NotNull ExternalSystemTaskId id, final @NotNull List<String> taskNames, @NotNull String projectPath, final @Nullable GradleExecutionSettings settings, final @NotNull List<String> vmOptions, final @NotNull List<String> scriptParameters, final @Nullable String debuggerSetup, final @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, taskNames, projectPath, settings, vmOptions, scriptParameters, debuggerSetup, listener)) continue;
                return;
            }
        }
        Function<ProjectConnection, Void> f = new Function<ProjectConnection, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void fun(ProjectConnection connection) {
                GradleVersion gradleVersion;
                GradleProjectResolverExtension projectResolverChain;
                final ArrayList initScripts = ContainerUtil.newArrayList();
                for (GradleProjectResolverExtension resolverExtension = projectResolverChain = GradleProjectResolver.createProjectResolverChain(settings); resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
                    final String resolverClassName = resolverExtension.getClass().getName();
                    resolverExtension.enhanceTaskProcessing(taskNames, debuggerSetup, new Consumer<String>(){

                        public void consume(String script) {
                            if (StringUtil.isNotEmpty((String)script)) {
                                ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                            }
                        }
                    });
                }
                if (!initScripts.isEmpty()) {
                    try {
                        File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((Collection)initScripts, (String)SystemProperties.getLineSeparator()));
                        ContainerUtil.addAll((Collection)scriptParameters, (Object[])new String[]{"--init-script", tempFile.getAbsolutePath()});
                    }
                    catch (IOException e) {
                        throw new ExternalSystemException((Throwable)e);
                    }
                }
                if ((gradleVersion = GradleExecutionHelper.getGradleVersion(connection)) != null && gradleVersion.compareTo(GradleVersion.version((String)"2.5")) < 0) {
                    listener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemProgressEventUnsupportedImpl(gradleVersion + " does not support executions view")));
                }
                BuildLauncher launcher = GradleTaskManager.this.myHelper.getBuildLauncher(id, connection, settings, listener, vmOptions, scriptParameters);
                launcher.forTasks(ArrayUtil.toStringArray((Collection)taskNames));
                if (gradleVersion != null && gradleVersion.compareTo(GradleVersion.version((String)"2.1")) < 0) {
                    GradleTaskManager.this.myCancellationMap.put(id, new UnsupportedCancellationToken());
                } else {
                    CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
                    launcher.withCancellationToken(cancellationTokenSource.token());
                    GradleTaskManager.this.myCancellationMap.put(id, cancellationTokenSource);
                }
                try {
                    launcher.run();
                }
                finally {
                    GradleTaskManager.this.myCancellationMap.remove(id);
                }
                return null;
            }
        };
        this.myHelper.execute(projectPath, settings, f);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener)) continue;
                return true;
            }
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
        }
        return true;
    }
}

