/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.io.File;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class IdeaGradleSystemSettingsControlBuilder
implements GradleSystemSettingsControlBuilder {
    @NotNull
    private final GradleSettings myInitialSettings;
    @Nullable
    private JBLabel myServiceDirectoryLabel;
    @Nullable
    private TextFieldWithBrowseButton myServiceDirectoryPathField;
    private boolean myServiceDirectoryPathModifiedByUser;
    private boolean dropServiceDirectory;
    @Nullable
    private JBLabel myGradleVmOptionsLabel;
    @Nullable
    private JBTextField myGradleVmOptionsField;
    private boolean dropVmOptions;
    @Nullable
    private JBCheckBox myOfflineModeBox;
    private boolean dropOfflineModeBox;

    public IdeaGradleSystemSettingsControlBuilder(@NotNull GradleSettings initialSettings) {
        this.myInitialSettings = initialSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (!this.dropOfflineModeBox) {
            this.myOfflineModeBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.offline_work", new Object[0]));
            canvas.add((Component)this.myOfflineModeBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
        this.addServiceDirectoryControl(canvas, indentLevel);
        if (!this.dropVmOptions) {
            this.myGradleVmOptionsLabel = new JBLabel(GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            canvas.add((Component)this.myGradleVmOptionsLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            this.myGradleVmOptionsField = new JBTextField();
            canvas.add((Component)this.myGradleVmOptionsField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        }
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
    }

    @Override
    public void reset() {
        if (this.myServiceDirectoryPathField != null) {
            this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            this.myServiceDirectoryPathField.setText("");
            String path = this.myInitialSettings.getServiceDirectoryPath();
            if (StringUtil.isEmpty((String)path)) {
                IdeaGradleSystemSettingsControlBuilder.deduceServiceDirectory(this.myServiceDirectoryPathField);
                this.myServiceDirectoryPathModifiedByUser = false;
            } else {
                this.myServiceDirectoryPathField.setText(path);
            }
        }
        if (this.myGradleVmOptionsField != null) {
            this.myGradleVmOptionsField.setText(IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myInitialSettings.getGradleVmOptions()));
        }
        if (this.myOfflineModeBox != null) {
            this.myOfflineModeBox.setSelected(this.myInitialSettings.isOfflineWork());
        }
    }

    @Override
    public boolean isModified() {
        if (this.myServiceDirectoryPathModifiedByUser && this.myServiceDirectoryPathField != null && !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myServiceDirectoryPathField.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myInitialSettings.getServiceDirectoryPath()))) {
            return true;
        }
        if (this.myGradleVmOptionsField != null && !Comparing.equal((String)IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myGradleVmOptionsField.getText()), (String)IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myInitialSettings.getGradleVmOptions()))) {
            return true;
        }
        return this.myOfflineModeBox != null && this.myOfflineModeBox.isSelected() != this.myInitialSettings.isOfflineWork();
    }

    @Override
    public void apply(@NotNull GradleSettings settings) {
        if (this.myServiceDirectoryPathField != null && this.myServiceDirectoryPathModifiedByUser) {
            settings.setServiceDirectoryPath(ExternalSystemApiUtil.normalizePath((String)this.myServiceDirectoryPathField.getText()));
        }
        if (this.myGradleVmOptionsField != null) {
            settings.setGradleVmOptions(IdeaGradleSystemSettingsControlBuilder.trimIfPossible(this.myGradleVmOptionsField.getText()));
        }
        if (this.myOfflineModeBox != null) {
            settings.setOfflineWork(this.myOfflineModeBox.isSelected());
        }
    }

    @Override
    public boolean validate(@NotNull GradleSettings settings) {
        return true;
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
    }

    @Override
    @NotNull
    public GradleSettings getInitialSettings() {
        return this.myInitialSettings;
    }

    public IdeaGradleSystemSettingsControlBuilder dropServiceDirectory() {
        this.dropServiceDirectory = true;
        return this;
    }

    public IdeaGradleSystemSettingsControlBuilder dropVmOptions() {
        this.dropVmOptions = true;
        return this;
    }

    public IdeaGradleSystemSettingsControlBuilder dropOfflineModeBox() {
        this.dropOfflineModeBox = true;
        return this;
    }

    private void addServiceDirectoryControl(PaintAwarePanel canvas, int indentLevel) {
        if (this.dropServiceDirectory) {
            return;
        }
        this.myServiceDirectoryLabel = new JBLabel(GradleBundle.message("gradle.settings.text.service.dir.path", new Object[0]));
        this.myServiceDirectoryPathField = new TextFieldWithBrowseButton();
        this.myServiceDirectoryPathField.addBrowseFolderListener("", GradleBundle.message("gradle.settings.title.service.dir.path", new Object[0]), null, new FileChooserDescriptor(false, true, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        this.myServiceDirectoryPathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdeaGradleSystemSettingsControlBuilder.this.myServiceDirectoryPathModifiedByUser = true;
                IdeaGradleSystemSettingsControlBuilder.this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdeaGradleSystemSettingsControlBuilder.this.myServiceDirectoryPathModifiedByUser = true;
                IdeaGradleSystemSettingsControlBuilder.this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        canvas.add((Component)this.myServiceDirectoryLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        canvas.add((Component)this.myServiceDirectoryPathField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
    }

    private static void deduceServiceDirectory(@NotNull TextFieldWithBrowseButton serviceDirectoryPathField) {
        File gradleUserHomeDir = new BuildLayoutParameters().getGradleUserHomeDir();
        serviceDirectoryPathField.setText(FileUtil.toSystemIndependentName((String)gradleUserHomeDir.getPath()));
        serviceDirectoryPathField.getTextField().setForeground(LocationSettingType.DEDUCED.getColor());
    }

    @Nullable
    private static String trimIfPossible(@Nullable String s) {
        return StringUtil.nullize((String)StringUtil.trim((String)s));
    }
}

