/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.gradle.tooling.UnsupportedVersionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class BaseProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + BaseProjectImportErrorHandler.class.getName()));

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String errMessage;
        String msg;
        if (error instanceof ExternalSystemException) {
            return (ExternalSystemException)error;
        }
        LOG.info(String.format("Failed to import Gradle project at '%1$s'", projectPath), error);
        if (error instanceof ProcessCanceledException) {
            return new ExternalSystemException("Project import was cancelled");
        }
        Pair<Throwable, String> rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        String location = (String)rootCauseAndLocation.getSecond();
        if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
            location = String.format("Build file: '%1$s'", buildFilePath);
        }
        if (rootCause instanceof UnsupportedVersionException) {
            String msg2 = "You are using unsupported version of Gradle.";
            msg2 = msg2 + "\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError(msg2, null, new String[0]);
        }
        String rootCauseText = rootCause.toString();
        if (StringUtil.startsWith((CharSequence)rootCauseText, (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
            String method = this.parseMissingMethod(rootCauseText);
            String msg3 = "Build script error, unsupported Gradle DSL method found: '" + method + "'!";
            msg3 = msg3 + "\n\nPossible causes could be:  ";
            msg3 = msg3 + String.format("%s  - you are using Gradle version where the method is absent (<a href=\"%s\">Fix Gradle settings</a>)", Character.valueOf('\n'), "open_gradle_settings");
            msg3 = msg3 + String.format("%s  - you didn't apply Gradle plugin which provides the method (<a href=\"%s\">Apply Gradle plugin</a>)", Character.valueOf('\n'), "apply_gradle_plugin");
            msg3 = msg3 + String.format("%s  - or there is a mistake in a build script (<a href=\"%s\">Goto source</a>)", Character.valueOf('\n'), "goto_source");
            return this.createUserFriendlyError(msg3, location, "open_gradle_settings", "apply_gradle_plugin", "goto_source");
        }
        if (rootCause instanceof OutOfMemoryError) {
            String originalMessage = rootCause.getMessage();
            String msg4 = "Out of memory";
            if (originalMessage != null && !originalMessage.isEmpty()) {
                msg4 = msg4 + ": " + originalMessage;
            }
            if (msg4.endsWith("Java heap space")) {
                msg4 = msg4 + ". Configure Gradle memory settings using '-Xmx' JVM option (e.g. '-Xmx2048m'.)";
            } else if (!msg4.endsWith(".")) {
                msg4 = msg4 + ".";
            }
            msg4 = msg4 + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(msg4, null, new String[0]);
        }
        if (rootCause instanceof ClassNotFoundException) {
            String msg5 = String.format("Unable to load class '%1$s'.", rootCause.getMessage()) + "\n\n" + "This is an unexpected error. Please file a bug containing the idea.log file.";
            return this.createUserFriendlyError(msg5, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            String msg6 = String.format("Unknown host '%1$s'.", rootCause.getMessage()) + "\n\n" + "Please ensure the host name is correct. " + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(msg6, null, new String[0]);
        }
        if (rootCause instanceof ConnectException && (msg = rootCause.getMessage()) != null && msg.contains("timed out")) {
            msg = msg + (msg.endsWith(".") ? " " : ". ");
            msg = msg + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause instanceof RuntimeException && (msg = rootCause.getMessage()) != null && UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN.matcher(msg).matches()) {
            if (!msg.endsWith(".")) {
                msg = msg + ".";
            }
            msg = msg + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause.getMessage() == null) {
            StringWriter writer = new StringWriter();
            rootCause.printStackTrace(new PrintWriter(writer));
            errMessage = writer.toString();
        } else {
            errMessage = rootCause.getMessage();
        }
        return this.createUserFriendlyError(errMessage, location, new String[0]);
    }
}

