/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.Jar;

public class Ear
extends Jar {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myAppDirName;
    @NotNull
    private final String myLibDirName;
    private String myDeploymentDescriptor;
    @NotNull
    private List<EarResource> myResources = Collections.emptyList();

    public Ear(@NotNull String name, @NotNull String appDirName, @NotNull String libDirName) {
        super(name);
        this.myAppDirName = appDirName;
        this.myLibDirName = libDirName;
    }

    @NotNull
    public String getAppDirName() {
        return this.myAppDirName;
    }

    @NotNull
    public String getLibDirName() {
        return this.myLibDirName;
    }

    public void setDeploymentDescriptor(String deploymentDescriptor) {
        this.myDeploymentDescriptor = deploymentDescriptor;
    }

    public String getDeploymentDescriptor() {
        return this.myDeploymentDescriptor;
    }

    @NotNull
    public List<EarResource> getResources() {
        return this.myResources;
    }

    public void setResources(@NotNull List<EarResource> resources) {
        this.myResources = resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ear)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ear that = (Ear)o;
        if (!this.myAppDirName.equals(that.myAppDirName)) {
            return false;
        }
        return this.myLibDirName.equals(that.myLibDirName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myAppDirName.hashCode();
        result = 31 * result + this.myLibDirName.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Ear{appDirName='" + this.myAppDirName + '\'' + ", libDirName='" + this.myLibDirName + '\'' + '}';
    }
}

