/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public abstract class AbstractTestEvent
implements TestEvent {
    private final GradleTestsExecutionConsole myExecutionConsole;

    public AbstractTestEvent(GradleTestsExecutionConsole executionConsole) {
        this.myExecutionConsole = executionConsole;
    }

    public GradleTestsExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.myExecutionConsole.getResultsViewer();
    }

    protected Project getProject() {
        return this.myExecutionConsole.getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getExecutionConsole().getProperties();
    }

    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        return GradleRunnerUtil.getTestLocationUrl(name, fqClassName);
    }

    protected String getTestName(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        return eventXml.queryXml("/ijLog/event/test/descriptor/@name");
    }

    protected String getParentTestId(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        return eventXml.queryXml("/ijLog/event/test/@parentId");
    }

    protected String getTestId(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        return eventXml.queryXml("/ijLog/event/test/@id");
    }

    protected String getTestClassName(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        return eventXml.queryXml("/ijLog/event/test/descriptor/@className");
    }

    protected TestEventResult getTestEventResultType(@NotNull XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        return TestEventResult.fromValue(eventXml.queryXml("/ijLog/event/test/result/@resultType"));
    }

    protected void addToInvokeLater(Runnable runnable) {
        ExternalSystemApiUtil.addToInvokeLater((Runnable)runnable);
    }

    @Nullable
    protected SMTestProxy findTestProxy(String proxyId) {
        return this.getExecutionConsole().getTestsMap().get(proxyId);
    }

    protected void registerTestProxy(String proxyId, SMTestProxy testProxy) {
        this.myExecutionConsole.getTestsMap().put(proxyId, testProxy);
    }
}

