/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.action.GradleRerunFailedTestsAction;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ConfigurationErrorEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ReportLocationEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventType;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class GradleTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, GradleTestsExecutionConsole, ProcessHandler> {
    private static final Logger LOG = Logger.getInstance(GradleTestsExecutionConsoleManager.class);

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    @NotNull
    public GradleTestsExecutionConsole attachExecutionConsole(@NotNull ExternalSystemTask task, @NotNull Project project, @NotNull ExternalSystemRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) throws ExecutionException {
        ExternalSystemExecuteTaskTask executeTask;
        TestTreeRenderer originalRenderer;
        GradleConsoleProperties consoleProperties = new GradleConsoleProperties(configuration, executor);
        String testFrameworkName = configuration.getSettings().getExternalSystemId().getReadableName();
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)testFrameworkName);
        GradleTestsExecutionConsole consoleView = new GradleTestsExecutionConsole((TestConsoleProperties)consoleProperties, splitterPropertyName);
        consoleView.initTaskExecutionView(project, processHandler, task.getId());
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)testFrameworkName);
        consoleView.attachToProcess(processHandler);
        TestTreeView testTreeView = consoleView.getResultsViewer().getTreeView();
        if (testTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)testTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
            originalRenderer.setAdditionalRootFormatter(new SMRootTestProxyFormatter(){

                public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer) {
                    TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
                    if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
                        renderer.clear();
                        renderer.append(GradleBundle.message("gradle.test.runner.ui.tests.tree.presentation.labels.waiting.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (!testProxy.isInProgress() && testProxy.isEmptySuite()) {
                        renderer.clear();
                        renderer.append(GradleBundle.message("gradle.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
        }
        if (task instanceof ExternalSystemExecuteTaskTask && ((executeTask = (ExternalSystemExecuteTaskTask)task).getScriptParameters() == null || !StringUtil.contains((CharSequence)executeTask.getScriptParameters(), (CharSequence)"--tests"))) {
            executeTask.appendScriptParameters("--tests *");
        }
        return consoleView;
    }

    public void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        StringBuilder consoleBuffer = executionConsole.getBuffer();
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"<ijLogEol/>\n")) {
            consoleBuffer.append(StringUtil.trimEnd((String)text, (String)"<ijLogEol/>\n")).append('\n');
            return;
        }
        consoleBuffer.append(text);
        String trimmedText = consoleBuffer.toString().trim();
        consoleBuffer.setLength(0);
        if (!StringUtil.startsWith((CharSequence)trimmedText, (CharSequence)"<ijLog>") || !StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)"</ijLog>")) {
            if (text.trim().isEmpty()) {
                return;
            }
            executionConsole.print(text, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            return;
        }
        try {
            XmlXpathHelper xml = new XmlXpathHelper(trimmedText);
            TestEventType eventType = TestEventType.fromValue(xml.queryXml("/ijLog/event/@type"));
            AbstractTestEvent testEvent = null;
            switch (eventType) {
                case CONFIGURATION_ERROR: {
                    testEvent = new ConfigurationErrorEvent(executionConsole);
                    break;
                }
                case REPORT_LOCATION: {
                    testEvent = new ReportLocationEvent(executionConsole);
                    break;
                }
                case BEFORE_TEST: {
                    testEvent = new BeforeTestEvent(executionConsole);
                    break;
                }
                case ON_OUTPUT: {
                    testEvent = new OnOutputEvent(executionConsole);
                    break;
                }
                case AFTER_TEST: {
                    testEvent = new AfterTestEvent(executionConsole);
                    break;
                }
                case BEFORE_SUITE: {
                    testEvent = new BeforeSuiteEvent(executionConsole);
                    break;
                }
                case AFTER_SUITE: {
                    testEvent = new AfterSuiteEvent(executionConsole);
                    break;
                }
            }
            if (testEvent != null) {
                testEvent.process(xml);
            }
        }
        catch (XmlXpathHelper.XmlParserException e) {
            LOG.error("Gradle test events parser error", (Throwable)e);
        }
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        if (task instanceof ExternalSystemExecuteTaskTask) {
            final ExternalSystemExecuteTaskTask taskTask = (ExternalSystemExecuteTaskTask)task;
            if (!StringUtil.equals((CharSequence)taskTask.getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId())) {
                return false;
            }
            return ContainerUtil.find((Iterable)taskTask.getTasksToExecute(), (Condition)new Condition<ExternalTaskPojo>(){

                public boolean value(ExternalTaskPojo pojo) {
                    ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)taskTask.getIdeProject(), (ProjectSystemId)GradleTestsExecutionConsoleManager.this.getExternalSystemId(), (String)pojo.getLinkedExternalProjectPath());
                    if (externalProjectInfo == null) {
                        return false;
                    }
                    DataNode<TaskData> taskDataNode = GradleProjectResolverUtil.findTask((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure(), pojo.getLinkedExternalProjectPath(), pojo.getName());
                    return taskDataNode != null && ("check".equals(((TaskData)taskDataNode.getData()).getName()) && "verification".equals(((TaskData)taskDataNode.getData()).getGroup()) || "org.gradle.api.tasks.testing.Test".equals(((TaskData)taskDataNode.getData()).getType()));
                }
            }) != null;
        }
        return false;
    }

    public AnAction[] getRestartActions(final @NotNull GradleTestsExecutionConsole consoleView) {
        GradleRerunFailedTestsAction rerunFailedTestsAction = new GradleRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return consoleView.getResultsViewer();
            }
        });
        return new AnAction[]{rerunFailedTestsAction};
    }
}

