/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSMTestProxy
extends SMTestProxy {
    @Nullable
    private final String myClassName;
    @Nullable
    private String myStacktrace;
    @Nullable
    private String myParentId;

    public GradleSMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, @Nullable String className) {
        super(testName, isSuite, locationUrl);
        this.myClassName = className;
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestFailed(localizedMessage, stackTrace, testError);
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText);
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestIgnored(ignoreComment, stackTrace);
    }

    @Nullable
    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (this.getLocationUrl() != null && this.isDefect() && this.myStacktrace != null) {
            String[] stackTrace;
            for (String aStackTrace : stackTrace = new LineTokenizer(this.myStacktrace).execute()) {
                StackTraceLine line = new StackTraceLine(project, aStackTrace);
                if (!this.getName().equals(line.getMethodName()) || !StringUtil.equals((CharSequence)this.myClassName, (CharSequence)line.getClassName())) continue;
                return line.getMethodLocation(project);
            }
        }
        return super.getLocation(project, searchScope);
    }

    @Nullable
    public String getParentId() {
        return this.myParentId;
    }

    public void setParentId(@Nullable String parentId) {
        this.myParentId = parentId;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }
}

