/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyValue;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.GradlePluginDescriptionsExtension;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginActionHandler;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class AddGradleDslPluginAction
extends CodeInsightAction {
    public static final String ID = "AddGradleDslPluginAction";
    static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private final KeyValue[] myPlugins;

    public AddGradleDslPluginAction() {
        this.getTemplatePresentation().setDescription(GradleBundle.message("gradle.codeInsight.action.apply_plugin.description", new Object[0]));
        this.getTemplatePresentation().setText(GradleBundle.message("gradle.codeInsight.action.apply_plugin.text", new Object[0]));
        this.getTemplatePresentation().setIcon(GradleIcons.GradlePlugin);
        ArrayList<KeyValue> pluginDescriptions = new ArrayList<KeyValue>();
        for (GradlePluginDescriptionsExtension extension : (GradlePluginDescriptionsExtension[])GradlePluginDescriptionsExtension.EP_NAME.getExtensions()) {
            for (Map.Entry<String, String> pluginDescription : extension.getPluginDescriptions().entrySet()) {
                pluginDescriptions.add(KeyValue.create((Object)pluginDescription.getKey(), (Object)pluginDescription.getValue()));
            }
        }
        this.myPlugins = pluginDescriptions.toArray(new KeyValue[pluginDescriptions.size()]);
        Arrays.sort(this.myPlugins, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue o1, KeyValue o2) {
                return String.valueOf(o1.getKey()).compareTo(String.valueOf(o2.getKey()));
            }
        });
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new AddGradleDslPluginActionHandler(this.myPlugins);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!GroovyFileType.GROOVY_FILE_TYPE.equals(file.getFileType())) {
            return false;
        }
        return !"settings.gradle".equals(file.getName()) && file.getName().endsWith("gradle");
    }
}

