/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ProjectTopics;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.importProject.CloudGitChooseAccountStepBase;
import com.intellij.remoteServer.util.importProject.CloudGitProjectRoot;
import com.intellij.remoteServer.util.importProject.CloudGitProjectStructureDetector;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.actions.GitInit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CloudGitChooseAccountStepImpl
extends CloudGitChooseAccountStepBase {
    private final ProjectFromSourcesBuilder myBuilder;
    private final ProjectDescriptor myProjectDescriptor;
    private final CloudGitProjectStructureDetector myStructureDetector;

    public CloudGitChooseAccountStepImpl(CloudGitDeploymentDetector deploymentDetector, CloudGitProjectStructureDetector structureDetector, ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor) {
        super(deploymentDetector, builder.getContext());
        this.myBuilder = builder;
        this.myProjectDescriptor = projectDescriptor;
        this.myStructureDetector = structureDetector;
    }

    public boolean isStepVisible() {
        final Ref result = new Ref((Object)false);
        new RootIterator(){

            @Override
            protected void processProjectRoot(CloudGitProjectRoot root) {
                result.set((Object)true);
            }

            @Override
            protected void processJavaSourceRoot(DetectedSourceRoot root) {
            }
        }.iterate();
        return (Boolean)result.get();
    }

    @Override
    public void updateDataModel() {
        super.updateDataModel();
        final MultiMap project2sourceRoots = new MultiMap();
        new RootIterator(){
            CloudGitProjectRoot lastProjectRoot = null;

            @Override
            protected void processProjectRoot(CloudGitProjectRoot root) {
                this.lastProjectRoot = root;
                project2sourceRoots.put((Object)this.lastProjectRoot, new ArrayList());
            }

            @Override
            protected void processJavaSourceRoot(DetectedSourceRoot root) {
                project2sourceRoots.putValue((Object)this.lastProjectRoot, (Object)root);
            }
        }.iterate();
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>(this.myProjectDescriptor.getModules());
        for (Map.Entry project2sourceRootsEntry : project2sourceRoots.entrySet()) {
            final CloudGitProjectRoot projectRoot = (CloudGitProjectRoot)((Object)project2sourceRootsEntry.getKey());
            final File directory = projectRoot.getDirectory();
            ModuleDescriptor moduleDescriptor = new ModuleDescriptor(directory, StdModuleTypes.JAVA, (Collection)project2sourceRootsEntry.getValue());
            final String applicationName = projectRoot.getApplicationName();
            moduleDescriptor.addConfigurationUpdater(new ModuleBuilder.ModuleConfigurationUpdater(){

                public void update(final @NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                    final MessageBusConnection connection = module.getProject().getMessageBus().connect();
                    connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

                        public void moduleAdded(@NotNull Project project, @NotNull Module addedModule) {
                            if (addedModule == module) {
                                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.onModuleAdded(module);
                                    }
                                });
                                connection.disconnect();
                            }
                        }
                    });
                }

                private void onModuleAdded(Module module) {
                    CloudGitChooseAccountStepImpl.this.createRunConfiguration(module, applicationName);
                    GitInit.refreshAndConfigureVcsMappings((Project)module.getProject(), (VirtualFile)projectRoot.getRepositoryRoot(), (String)directory.getAbsolutePath());
                }
            });
            modules.add(moduleDescriptor);
        }
        this.myProjectDescriptor.setModules(modules);
    }

    private abstract class RootIterator {
        private RootIterator() {
        }

        public void iterate() {
            Collection roots = CloudGitChooseAccountStepImpl.this.myBuilder.getProjectRoots((ProjectStructureDetector)CloudGitChooseAccountStepImpl.this.myStructureDetector);
            CloudGitDeploymentDetector point = CloudGitChooseAccountStepImpl.this.getDeploymentDetector();
            String projectRootTypeName = CloudGitProjectRoot.getProjectRootTypeName(point);
            String javaSourceRootTypeName = CloudGitProjectRoot.getJavaSourceRootTypeName(point);
            for (DetectedProjectRoot root : roots) {
                if (root instanceof CloudGitProjectRoot && root.getRootTypeName().equals(projectRootTypeName)) {
                    this.processProjectRoot((CloudGitProjectRoot)root);
                    continue;
                }
                if (!(root instanceof DetectedSourceRoot) || !root.getRootTypeName().equals(javaSourceRootTypeName)) continue;
                this.processJavaSourceRoot((DetectedSourceRoot)root);
            }
        }

        protected abstract void processProjectRoot(CloudGitProjectRoot var1);

        protected abstract void processJavaSourceRoot(DetectedSourceRoot var1);
    }
}

