/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CloudGitChooseAccountStepBase
extends ModuleWizardStep {
    private JPanel myAccountSelectionPanelPlaceHolder;
    private JPanel myMainPanel;
    private JLabel myTitleLabel;
    private CloudAccountSelectionEditor myEditor;
    private final CloudGitDeploymentDetector myDeploymentDetector;
    private final WizardContext myContext;

    public CloudGitChooseAccountStepBase(CloudGitDeploymentDetector deploymentDetector, WizardContext context) {
        this.myDeploymentDetector = deploymentDetector;
        this.myContext = context;
        this.$$$setupUI$$$();
        ServerType cloudType = deploymentDetector.getCloudType();
        this.myTitleLabel.setText(CloudBundle.getText((String)"choose.account.title", (Object[])new Object[]{cloudType.getPresentableName()}));
        this.myEditor = new CloudAccountSelectionEditor(Collections.singletonList(cloudType));
        this.myAccountSelectionPanelPlaceHolder.add(this.myEditor.getMainPanel());
    }

    protected CloudGitDeploymentDetector getDeploymentDetector() {
        return this.myDeploymentDetector;
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public boolean validate() throws ConfigurationException {
        this.myEditor.validate();
        return super.validate();
    }

    public void updateDataModel() {
        this.myEditor.setAccountOnContext(this.myContext);
    }

    public void createRunConfiguration(Module module, String applicationName) {
        CloudDeploymentNameConfiguration deploymentConfiguration = this.myDeploymentDetector.createDeploymentConfiguration();
        boolean defaultName = module.getName().equals(applicationName);
        deploymentConfiguration.setDefaultDeploymentName(defaultName);
        if (!defaultName) {
            deploymentConfiguration.setDeploymentName(applicationName);
        }
        CloudAccountSelectionEditor.createRunConfiguration((WizardContext)this.myContext, (ServerType)this.myDeploymentDetector.getCloudType(), (Module)module, (CloudDeploymentNameConfiguration)deploymentConfiguration);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Choose <cloud> account:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAccountSelectionPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

