/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jogamp.common.Debug;
import jogamp.common.os.elf.ElfHeaderPart1;
import jogamp.common.os.elf.ElfHeaderPart2;

public abstract class PlatformPropsImpl {
    static final boolean DEBUG;
    public static final VersionNumber Version16;
    public static final VersionNumber Version17;
    public static final VersionNumber Version18;
    public static final VersionNumber Version19;
    public static final String OS;
    public static final String OS_lower;
    public static final String OS_VERSION;
    public static final VersionNumber OS_VERSION_NUMBER;
    public static final String ARCH;
    public static final String ARCH_lower;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VERSION;
    public static final VersionNumber JAVA_VERSION_NUMBER;
    public static final int JAVA_VERSION_UPDATE;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_RUNTIME_NAME;
    public static final boolean JAVA_SE;
    public static final boolean JAVA_6;
    public static final String NEWLINE;
    public static final boolean LITTLE_ENDIAN;
    public static final Platform.CPUType CPU_ARCH;
    public static final Platform.ABIType ABI_TYPE;
    public static final Platform.OSType OS_TYPE;
    public static final String os_and_arch;

    public static final boolean isCompatible(Platform.CPUType cPUType, Platform.ABIType aBIType, Platform.CPUType cPUType2, Platform.ABIType aBIType2) {
        return cPUType.isCompatible(cPUType2) && aBIType.isCompatible(aBIType2);
    }

    protected PlatformPropsImpl() {
    }

    private static final String getJavaRuntimeNameImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    private static final boolean initIsJavaSE() {
        if (null != JAVA_RUNTIME_NAME && JAVA_RUNTIME_NAME.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static final boolean queryIsLittleEndianImpl() {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == shortBuffer.get(0);
    }

    private static final boolean contains(String string, String[] stringArray) {
        if (null != string && null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static final File queryElfFile(Platform.OSType oSType) {
        File file;
        block7: {
            file = null;
            try {
                if (Platform.OSType.ANDROID == oSType) {
                    file = new File(NativeLibrary.findLibrary("gluegen-rt", PlatformPropsImpl.class.getClassLoader()));
                } else {
                    if (Platform.OSType.LINUX == oSType && !PlatformPropsImpl.checkFileReadAccess(file = new File("/proc/self/exe"))) {
                        file = null;
                    }
                    if (null == file) {
                        file = PlatformPropsImpl.findSysLib("java");
                    }
                    if (null == file) {
                        file = PlatformPropsImpl.findSysLib("jvm");
                    }
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block7;
                throwable.printStackTrace();
            }
        }
        return file;
    }

    private static final ElfHeaderPart1 readElfHeaderPart1(Platform.OSType oSType, RandomAccessFile randomAccessFile) {
        ElfHeaderPart1 elfHeaderPart1;
        block2: {
            elfHeaderPart1 = null;
            try {
                elfHeaderPart1 = ElfHeaderPart1.read(oSType, randomAccessFile);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                String string = String.valueOf(throwable.getMessage());
                System.err.println(string.length() != 0 ? "Caught: ".concat(string) : new String("Caught: "));
                throwable.printStackTrace();
            }
        }
        return elfHeaderPart1;
    }

    private static final ElfHeaderPart2 readElfHeaderPart2(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) {
        ElfHeaderPart2 elfHeaderPart2;
        block2: {
            elfHeaderPart2 = null;
            try {
                elfHeaderPart2 = ElfHeaderPart2.read(elfHeaderPart1, randomAccessFile);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                String string = String.valueOf(throwable.getMessage());
                System.err.println(string.length() != 0 ? "Caught: ".concat(string) : new String("Caught: "));
                throwable.printStackTrace();
            }
        }
        return elfHeaderPart2;
    }

    private static boolean checkFileReadAccess(File file) {
        try {
            return file.isFile() && file.canRead();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static File findSysLib(String string) {
        ClassLoader classLoader = PlatformPropsImpl.class.getClassLoader();
        List<String> list = NativeLibrary.enumerateLibraryPaths(string, string, string, true, classLoader);
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            int n;
            String string3 = list.get(i);
            File file = new File(string3);
            if (DEBUG) {
                n = i;
                string2 = String.valueOf(file);
                System.err.println(new StringBuilder(30 + String.valueOf(string2).length()).append("findSysLib #").append(n).append(": test ").append(string2).toString());
            }
            if (PlatformPropsImpl.checkFileReadAccess(file)) {
                return file;
            }
            if (!DEBUG) continue;
            n = i;
            string2 = String.valueOf(file);
            System.err.println(new StringBuilder(38 + String.valueOf(string2).length()).append("findSysLib #").append(n).append(": ").append(string2).append(" not readable").toString());
        }
        return null;
    }

    private static final Platform.OSType getOSTypeImpl(String string, boolean bl) throws RuntimeException {
        if (bl) {
            return Platform.OSType.ANDROID;
        }
        if (string.startsWith("linux")) {
            return Platform.OSType.LINUX;
        }
        if (string.startsWith("freebsd")) {
            return Platform.OSType.FREEBSD;
        }
        if (string.startsWith("android")) {
            return Platform.OSType.ANDROID;
        }
        if (string.startsWith("mac os x") || string.startsWith("darwin")) {
            return Platform.OSType.MACOS;
        }
        if (string.startsWith("sunos")) {
            return Platform.OSType.SUNOS;
        }
        if (string.startsWith("hp-ux")) {
            return Platform.OSType.HPUX;
        }
        if (string.startsWith("windows")) {
            return Platform.OSType.WINDOWS;
        }
        if (string.startsWith("kd")) {
            return Platform.OSType.OPENKODE;
        }
        String string2 = OS_lower;
        String string3 = ARCH_lower;
        throw new RuntimeException(new StringBuilder(45 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Please port OS detection to your platform (").append(string2).append("/").append(string3).append(")").toString());
    }

    public static void initSingleton() {
    }

    public static final String getOSAndArch(Platform.OSType oSType, Platform.CPUType cPUType, Platform.ABIType aBIType, boolean bl) {
        String string;
        String string2;
        String string3;
        switch (cPUType) {
            case ARM: 
            case ARMv5: 
            case ARMv6: 
            case ARMv7: {
                if (Platform.ABIType.EABI_GNU_ARMHF == aBIType) {
                    string3 = "armv6hf";
                    break;
                }
                string3 = "armv6";
                break;
            }
            case X86_32: {
                string3 = "i586";
                break;
            }
            case PPC: {
                string3 = "ppc";
                break;
            }
            case MIPS_32: {
                string3 = bl ? "mipsel" : "mips";
                break;
            }
            case SuperH: {
                string3 = "superh";
                break;
            }
            case SPARC_32: {
                string3 = "sparc";
                break;
            }
            case ARM64: 
            case ARMv8_A: {
                string3 = "aarch64";
                break;
            }
            case X86_64: {
                string3 = "amd64";
                break;
            }
            case PPC64: {
                string3 = "ppc64";
                break;
            }
            case MIPS_64: {
                string3 = "mips64";
                break;
            }
            case IA64: {
                string3 = "ia64";
                break;
            }
            case SPARCV9_64: {
                string3 = "sparcv9";
                break;
            }
            case PA_RISC2_0: {
                string3 = "risc2.0";
                break;
            }
            default: {
                String string4 = String.valueOf((Object)cPUType);
                throw new InternalError(new StringBuilder(19 + String.valueOf(string4).length()).append("Unhandled CPUType: ").append(string4).toString());
            }
        }
        switch (oSType) {
            case ANDROID: {
                string2 = "android";
                string = string3;
                break;
            }
            case MACOS: {
                string2 = "macosx";
                string = "universal";
                break;
            }
            case WINDOWS: {
                string2 = "windows";
                string = string3;
                break;
            }
            case OPENKODE: {
                string2 = "openkode";
                string = string3;
                break;
            }
            case LINUX: {
                string2 = "linux";
                string = string3;
                break;
            }
            case FREEBSD: {
                string2 = "freebsd";
                string = string3;
                break;
            }
            case SUNOS: {
                string2 = "solaris";
                string = string3;
                break;
            }
            case HPUX: {
                string2 = "hpux";
                string = "hppa";
                break;
            }
            default: {
                String string5 = String.valueOf((Object)oSType);
                throw new InternalError(new StringBuilder(18 + String.valueOf(string5).length()).append("Unhandled OSType: ").append(string5).toString());
            }
        }
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append("-").append(string).toString();
    }

    static {
        int n;
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        int n2;
        DEBUG = Debug.debug("Platform");
        Version16 = new VersionNumber(1, 6, 0);
        Version17 = new VersionNumber(1, 7, 0);
        Version18 = new VersionNumber(1, 8, 0);
        Version19 = new VersionNumber(1, 9, 0);
        boolean bl = AndroidVersion.isAvailable;
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VERSION_NUMBER = new VersionNumber(JAVA_VERSION);
        int n3 = JAVA_VERSION.lastIndexOf("-u");
        if (0 < n3) {
            n2 = 2;
        } else {
            n3 = JAVA_VERSION.lastIndexOf("_");
            n2 = 1;
        }
        if (0 < n3) {
            object = JAVA_VERSION.substring(n3 + n2);
            VersionNumber versionNumber = new VersionNumber((String)object);
            JAVA_VERSION_UPDATE = versionNumber.getMajor();
        } else {
            JAVA_VERSION_UPDATE = 0;
        }
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_RUNTIME_NAME = PlatformPropsImpl.getJavaRuntimeNameImpl();
        JAVA_SE = PlatformPropsImpl.initIsJavaSE();
        JAVA_6 = JAVA_SE && (bl || JAVA_VERSION_NUMBER.compareTo(Version16) >= 0);
        NEWLINE = System.getProperty("line.separator");
        OS = System.getProperty("os.name");
        OS_lower = OS.toLowerCase();
        OS_VERSION = System.getProperty("os.version");
        OS_VERSION_NUMBER = new VersionNumber(OS_VERSION);
        OS_TYPE = PlatformPropsImpl.getOSTypeImpl(OS_lower, bl);
        final String[] stringArray = new String[]{null};
        Object object2 = new Platform.CPUType[]{null};
        Object object3 = new Platform.ABIType[]{null};
        Object object4 = new int[]{0};
        Object object5 = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction<Object>((Platform.CPUType[])object2, object3, object4, object5){
            final /* synthetic */ Platform.CPUType[] val$_elfCpuType;
            final /* synthetic */ Platform.ABIType[] val$_elfAbiType;
            final /* synthetic */ int[] val$_elfLittleEndian;
            final /* synthetic */ boolean[] val$_elfValid;
            {
                this.val$_elfCpuType = cPUTypeArray;
                this.val$_elfAbiType = aBITypeArray;
                this.val$_elfLittleEndian = nArray;
                this.val$_elfValid = blArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                RandomAccessFile randomAccessFile = null;
                try {
                    Object object;
                    Object object2;
                    File file = PlatformPropsImpl.queryElfFile(OS_TYPE);
                    if (DEBUG) {
                        object2 = String.valueOf(file);
                        System.err.println(new StringBuilder(13 + String.valueOf(object2).length()).append("ELF-1: Using ").append((String)object2).toString());
                    }
                    randomAccessFile = new RandomAccessFile(file, "r");
                    object2 = PlatformPropsImpl.readElfHeaderPart1(OS_TYPE, randomAccessFile);
                    if (DEBUG) {
                        object = String.valueOf(object2);
                        System.err.println(new StringBuilder(11 + String.valueOf(object).length()).append("ELF-1: Got ").append((String)object).toString());
                    }
                    if (null != object2) {
                        object = PlatformPropsImpl.readElfHeaderPart2((ElfHeaderPart1)object2, randomAccessFile);
                        if (DEBUG) {
                            String string = String.valueOf(object);
                            System.err.println(new StringBuilder(11 + String.valueOf(string).length()).append("ELF-2: Got ").append(string).toString());
                        }
                        if (null != object) {
                            stringArray[0] = ((ElfHeaderPart2)object).cpuName;
                            this.val$_elfCpuType[0] = ((ElfHeaderPart2)object).cpuType;
                            this.val$_elfAbiType[0] = ((ElfHeaderPart2)object).abiType;
                            if (((ElfHeaderPart1)object2).isLittleEndian()) {
                                this.val$_elfLittleEndian[0] = 1;
                            } else if (((ElfHeaderPart1)object2).isBigEndian()) {
                                this.val$_elfLittleEndian[0] = 2;
                            }
                            this.val$_elfValid[0] = true;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        throwable.printStackTrace();
                    }
                }
                finally {
                    if (null != randomAccessFile) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
        });
        String string5 = stringArray[0];
        Platform.CPUType cPUType = object2[0];
        object = object3[0];
        int n4 = object4[0];
        boolean bl2 = object5[0];
        if (DEBUG) {
            string4 = String.valueOf((Object)cPUType);
            string3 = String.valueOf(object);
            System.err.println(new StringBuilder(87 + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append("Platform.Elf: valid ").append(bl2).append(", elfCpuName ").append(string5).append(", cpuType ").append(string4).append(", abiType ").append(string3).append(", elfLittleEndian ").append(n4).toString());
        }
        boolean bl3 = PlatformPropsImpl.queryIsLittleEndianImpl();
        if (bl2) {
            switch (n4) {
                case 1: {
                    LITTLE_ENDIAN = true;
                    break;
                }
                case 2: {
                    LITTLE_ENDIAN = false;
                    break;
                }
                default: {
                    LITTLE_ENDIAN = bl3;
                    break;
                }
            }
        } else {
            LITTLE_ENDIAN = bl3;
        }
        if (DEBUG) {
            boolean bl4 = LITTLE_ENDIAN;
            System.err.println(new StringBuilder(92).append("Platform.Endian: test-little ").append(bl3).append(", elf[valid ").append(bl2).append(", val ").append(n4).append("] -> LITTLE_ENDIAN ").append(bl4).toString());
        }
        object2 = System.getProperty("os.arch");
        object3 = ((String)object2).toLowerCase();
        object4 = (Object)Platform.CPUType.query((String)object3);
        object5 = (Object)Platform.ABIType.query((Platform.CPUType)((Object)object4), (String)object3);
        if (DEBUG) {
            string4 = String.valueOf(object4);
            string3 = String.valueOf(object5);
            System.err.println(new StringBuilder(44 + String.valueOf(object2).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append("Platform.Property: ARCH ").append((String)object2).append(", CpuType ").append(string4).append(", ABIType ").append(string3).toString());
        }
        if (bl) {
            if (DEBUG) {
                string3 = AndroidVersion.CPU_ABI;
                string2 = String.valueOf((Object)AndroidVersion.CPU_TYPE);
                string = String.valueOf((Object)AndroidVersion.ABI_TYPE);
                System.err.println(new StringBuilder(44 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append("Android: CPU_ABI1 str ").append(string3).append(", CPU_TYPE ").append(string2).append(", ABI_TYPE ").append(string).toString());
                string3 = AndroidVersion.CPU_ABI2;
                string2 = String.valueOf((Object)AndroidVersion.CPU_TYPE2);
                string = String.valueOf((Object)AndroidVersion.ABI_TYPE2);
                System.err.println(new StringBuilder(46 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append("Android: CPU_ABI2 str ").append(string3).append(", CPU_TYPE2 ").append(string2).append(", ABI_TYPE2 ").append(string).toString());
            }
            if (bl2) {
                if (null != AndroidVersion.CPU_TYPE && PlatformPropsImpl.isCompatible(cPUType, (Platform.ABIType)((Object)object), AndroidVersion.CPU_TYPE, AndroidVersion.ABI_TYPE)) {
                    ARCH_lower = ARCH = AndroidVersion.CPU_ABI;
                    CPU_ARCH = AndroidVersion.CPU_TYPE;
                    n = 110;
                } else if (null != AndroidVersion.CPU_TYPE2 && PlatformPropsImpl.isCompatible(cPUType, (Platform.ABIType)((Object)object), AndroidVersion.CPU_TYPE2, AndroidVersion.ABI_TYPE2)) {
                    ARCH_lower = ARCH = AndroidVersion.CPU_ABI2;
                    CPU_ARCH = AndroidVersion.CPU_TYPE2;
                    n = 111;
                } else {
                    ARCH = cPUType.toString();
                    ARCH_lower = ARCH.toLowerCase();
                    CPU_ARCH = cPUType;
                    n = 112;
                }
                ABI_TYPE = object;
            } else if (AndroidVersion.CPU_TYPE.family == Platform.CPUFamily.ARM || null == AndroidVersion.CPU_TYPE2) {
                ARCH_lower = ARCH = AndroidVersion.CPU_ABI;
                CPU_ARCH = AndroidVersion.CPU_TYPE;
                ABI_TYPE = AndroidVersion.ABI_TYPE;
                n = 120;
            } else {
                ARCH_lower = ARCH = AndroidVersion.CPU_ABI2;
                CPU_ARCH = AndroidVersion.CPU_TYPE2;
                ABI_TYPE = AndroidVersion.ABI_TYPE2;
                n = 121;
            }
        } else if (bl2) {
            if (PlatformPropsImpl.isCompatible(cPUType, (Platform.ABIType)((Object)object), (Platform.CPUType)((Object)object4), (Platform.ABIType)((Object)object5))) {
                ARCH = object2;
                ARCH_lower = object3;
                CPU_ARCH = (Platform.CPUType)((Object)object4);
                ABI_TYPE = (Platform.ABIType)((Object)object5);
                n = 210;
            } else {
                ARCH = string5;
                ARCH_lower = string5;
                CPU_ARCH = cPUType;
                ABI_TYPE = object;
                n = 211;
            }
        } else {
            ARCH = object2;
            ARCH_lower = object3;
            CPU_ARCH = (Platform.CPUType)((Object)object4);
            ABI_TYPE = (Platform.ABIType)((Object)object5);
            n = 220;
        }
        if (DEBUG) {
            string3 = ARCH;
            string2 = String.valueOf((Object)CPU_ARCH);
            string = String.valueOf((Object)ABI_TYPE);
            System.err.println(new StringBuilder(98 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append("Platform.Hard: ARCH ").append(string3).append(", CPU_ARCH ").append(string2).append(", ABI_TYPE ").append(string).append(" - strategy ").append(n).append("(isAndroid ").append(bl).append(", elfValid ").append(bl2).append(")").toString());
        }
        os_and_arch = PlatformPropsImpl.getOSAndArch(OS_TYPE, CPU_ARCH, ABI_TYPE, LITTLE_ENDIAN);
    }

    public static class OSXVersion {
        public static final VersionNumber Tiger = new VersionNumber(10, 4, 0);
        public static final VersionNumber Lion = new VersionNumber(10, 7, 0);
        public static final VersionNumber Mavericks = new VersionNumber(10, 9, 0);
    }
}

