/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import java.io.PrintStream;

public class SourcedInterruptedException
extends InterruptedException
implements ExceptionUtils.CustomStackTrace {
    final Throwable interruptSource;

    public static InterruptedException wrap(InterruptedException interruptedException) {
        return SourcedInterruptedException.wrap(interruptedException, InterruptSource.Util.currentThread());
    }

    public static InterruptedException wrap(InterruptedException interruptedException, InterruptSource interruptSource) {
        if (!(interruptedException instanceof SourcedInterruptedException) && null != interruptSource) {
            return new SourcedInterruptedException(interruptedException, interruptSource.getInterruptSource(true));
        }
        return interruptedException;
    }

    public SourcedInterruptedException(String string, InterruptedException interruptedException, Throwable throwable) {
        super(string);
        if (null != interruptedException) {
            this.initCause(interruptedException);
        }
        this.interruptSource = throwable;
    }

    public SourcedInterruptedException(InterruptedException interruptedException, Throwable throwable) {
        super(interruptedException.getMessage());
        this.initCause(interruptedException);
        this.interruptSource = throwable;
    }

    public final Throwable getInterruptSource() {
        return this.interruptSource;
    }

    @Override
    public InterruptedException getCause() {
        return (InterruptedException)super.getCause();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.getClass().getSimpleName()).append(": ");
        if (null != this.interruptSource) {
            stringBuilder.append("[sourced]");
        } else {
            stringBuilder.append("[unknown]");
        }
        String string = this.getLocalizedMessage();
        if (null != string) {
            stringBuilder.append(" ").append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public final void printCauseStack(PrintStream printStream, String string, int n, int n2) {
        String string2 = new StringBuilder(13 + String.valueOf(string).length()).append(string).append("[").append(n).append("]").toString();
        String string3 = String.valueOf(this.getClass().getSimpleName());
        String string4 = String.valueOf(this.getMessage());
        String string5 = String.valueOf(Thread.currentThread().getName());
        printStream.println(new StringBuilder(17 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string2).append(" by ").append(string3).append(": ").append(string4).append(" on thread ").append(string5).toString());
        ExceptionUtils.dumpStack(printStream, this.getStackTrace(), 0, n2);
        if (null != this.interruptSource) {
            ExceptionUtils.printCause(printStream, string2, this.interruptSource, 0, 1, n2);
        }
    }

    @Override
    public final void printStackTrace(PrintStream printStream, int n, int n2) {
        String string = String.valueOf(this.getClass().getSimpleName());
        String string2 = String.valueOf(this.getMessage());
        String string3 = String.valueOf(Thread.currentThread().getName());
        printStream.println(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(": ").append(string2).append(" on thread ").append(string3).toString());
        ExceptionUtils.dumpStack(printStream, this.getStackTrace(), 0, n2);
        ExceptionUtils.printCause(printStream, "Caused", this.getCause(), 0, n, n2);
        if (null != this.interruptSource) {
            ExceptionUtils.printCause(printStream, "InterruptSource", this.interruptSource, 0, n, n2);
        }
    }
}

