/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import jogamp.common.util.Int32ArrayBitfield;
import jogamp.common.util.Int32Bitfield;
import jogamp.common.util.SyncedBitfield;

public interface Bitfield {
    public static final int UNSIGNED_INT_MAX_VALUE = -1;

    public int size();

    public void clearField(boolean var1);

    public int get32(int var1, int var2) throws IndexOutOfBoundsException;

    public void put32(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public int copy32(int var1, int var2, int var3) throws IndexOutOfBoundsException;

    public boolean get(int var1) throws IndexOutOfBoundsException;

    public boolean put(int var1, boolean var2) throws IndexOutOfBoundsException;

    public void set(int var1) throws IndexOutOfBoundsException;

    public void clear(int var1) throws IndexOutOfBoundsException;

    public boolean copy(int var1, int var2) throws IndexOutOfBoundsException;

    public int bitCount();

    public static class Factory {
        public static Bitfield create(int n) {
            if (32 >= n) {
                return new Int32Bitfield();
            }
            return new Int32ArrayBitfield(n);
        }

        public static Bitfield synchronize(Bitfield bitfield) {
            return new SyncedBitfield(bitfield);
        }
    }

    public static class Util {
        public static int getBitMask(int n) {
            if (32 > n) {
                return (1 << n) - 1;
            }
            if (32 == n) {
                return -1;
            }
            throw new IndexOutOfBoundsException(new StringBuilder(32).append("n <= 32 expected, is ").append(n).toString());
        }

        public static final int bitCount(int n) {
            n -= n >>> 1 & 0x55555555;
            n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
            n = n + (n >>> 4) & 0xF0F0F0F;
            n += n >>> 8;
            n += n >>> 16;
            return n & 0x3F;
        }
    }
}

