/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.model.EventAction;
import com.android.tools.adtui.model.EventRenderData;
import com.android.tools.adtui.model.RangedSimpleSeries;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SimpleEventComponent<E extends Enum<E>>
extends AnimatedComponent {
    public static final Color LINE_COLOR = new Color(166, 129, 184);
    private static final int LINE_OFFSET = 3;
    private static final int NORMALIZED_END = 1;
    private static final int HOLD_DELAY_MS = 150;
    @NotNull
    private final RangedSimpleSeries<EventAction<Action, E>> mData;
    @NotNull
    private final BufferedImage[] mIcons;
    @NotNull
    private final ArrayList<Shape> mPaths;
    @NotNull
    private final ArrayList<EventRenderData> mIconsToDraw;
    @NotNull
    private final int mImageWidth;
    @NotNull
    private final int mImageHeight;

    public SimpleEventComponent(@NotNull RangedSimpleSeries<EventAction<Action, E>> data, @NotNull BufferedImage[] icons) {
        this.mData = data;
        this.mIcons = icons;
        this.mPaths = new ArrayList();
        this.mIconsToDraw = new ArrayList();
        this.mImageWidth = this.mIcons[0].getWidth();
        this.mImageHeight = this.mIcons[0].getHeight();
    }

    @Override
    protected void updateData() {
        Path2D.Float path;
        Integer toDraw;
        double min = this.mData.getRange().getMin();
        double max = this.mData.getRange().getMax();
        EventAction<Action, E> downEvent = null;
        this.mIconsToDraw.clear();
        this.mPaths.clear();
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.mData.getSeries().size(); ++i) {
            EventAction<Action, E> data = this.mData.getSeries().get(i);
            if (data.getValue() == Action.DOWN) {
                downEvent = data;
                continue;
            }
            if (data.getValue() != Action.UP) continue;
            assert (downEvent != null);
            toDraw = ((Enum)data.getValueData()).ordinal();
            if (data.getEnd() - downEvent.getStart() >= 150L) {
                toDraw = ((Enum)downEvent.getValueData()).ordinal();
                path = new Path2D.Float();
                double start = ((double)downEvent.getStart() - min) / (max - min);
                double end = ((double)data.getEnd() - min) / (max - min);
                path.moveTo(start, 3.0);
                path.lineTo(end, 3.0);
                this.mPaths.add(path);
            }
            this.mIconsToDraw.add(new EventRenderData(toDraw, data.getEnd()));
            downEvent = null;
        }
        if (downEvent != null) {
            double start = ((double)downEvent.getStart() - min) / (max - min);
            toDraw = ((Enum)downEvent.getValueData()).ordinal();
            if (now - downEvent.getStart() >= 150L) {
                path = new Path2D.Float();
                double end = 1.0;
                path.moveTo(start, 3.0);
                path.lineTo(end, 3.0);
                this.mPaths.add(path);
                this.mIconsToDraw.add(new EventRenderData(toDraw, downEvent.getEnd()));
            }
        }
    }

    @Override
    protected void draw(Graphics2D g2d) {
        Dimension dim = this.getSize();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double min = this.mData.getRange().getMin();
        double max = this.mData.getRange().getMax();
        double scaleFactor = dim.getWidth();
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, 1.0);
        for (int i = 0; i < this.mIconsToDraw.size(); ++i) {
            EventRenderData data = this.mIconsToDraw.get(i);
            double normalizedPosition = ((double)data.getTimestamp() - min) / (max - min);
            if (data.getTimestamp() == 0L) {
                normalizedPosition = 1.0;
            }
            AffineTransform translate = AffineTransform.getTranslateInstance(normalizedPosition * scaleFactor - (double)this.mImageWidth / 2.0, 0.0);
            g2d.drawImage(this.mIcons[data.getIndex() % this.mIcons.length], translate, null);
        }
        Stroke current = g2d.getStroke();
        BasicStroke str = new BasicStroke(2.0f);
        g2d.setStroke(str);
        g2d.setColor(LINE_COLOR);
        for (int i = 0; i < this.mPaths.size(); ++i) {
            Shape shape = scale.createTransformedShape(this.mPaths.get(i));
            g2d.draw(shape);
        }
        g2d.setStroke(current);
    }

    @Override
    protected void debugDraw(Graphics2D g) {
        super.debugDraw(g);
    }

    public static enum Action {
        DOWN,
        UP;

    }
}

