/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.ReportingSeries;
import com.android.tools.adtui.model.ReportingSeriesRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class SelectionComponent
extends AnimatedComponent {
    public static final float ZOOM_FACTOR = 0.1f;
    private static final Dimension HANDLE_DIM = new Dimension(12, 40);
    private static final int DIM_ROUNDING_CORNER = 5;
    private static final int OVERLAY_INFO_PADDING = 5;
    private static final int OVERLAY_INFO_LINE_SPACING = 5;
    private static final int OVERLAY_INFO_COLUMN_SPACING = 10;
    private static final int OVERLAY_INFO_MIN_WIDTH = 200;
    private static final int OVERLAY_INFO_OFFSET = 10;
    private static final int OVERLAY_SHADOW_OFFSET = 2;
    private static final String OVERLAY_DRILL_DOWN_MESSAGE = "Double click to drill down";
    private Mode mode;
    @NotNull
    private final Component mHost;
    @NotNull
    private final AxisComponent mAxis;
    @NotNull
    private final Range mSelectionRange;
    @NotNull
    private final Range mDataRange;
    @NotNull
    private final Range mViewRange;
    private double mSelectionBlockClickOffset = 0.0;
    private boolean mZoomRequested;
    private double mZoomMinTarget;
    private double mZoomMaxTarget;
    private ReportingSeriesRenderer mReportingContainer;
    @NotNull
    private final Map<ReportingSeries, Collection<ReportingSeries.ReportingData>> mReportingData;

    public SelectionComponent(@NotNull Component host, @NotNull AxisComponent axis, @NotNull Range selectionRange, @NotNull Range dataRange, @NotNull Range viewRange) {
        this.mHost = host;
        this.mAxis = axis;
        this.mDataRange = dataRange;
        this.mViewRange = viewRange;
        this.mode = Mode.NO_SELECTION;
        this.mSelectionRange = selectionRange;
        this.mReportingData = new HashMap<ReportingSeries, Collection<ReportingSeries.ReportingData>>();
        this.initListeners();
    }

    private void initListeners() {
        this.mHost.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                Point mousePosition = SelectionComponent.this.getMouseLocation();
                SelectionComponent.this.mode = SelectionComponent.this.getModeForMousePosition(mousePosition);
                switch (SelectionComponent.this.mode) {
                    case NO_SELECTION: 
                    case CREATE: {
                        double value = SelectionComponent.this.mAxis.getValueAtPosition(mousePosition.x);
                        SelectionComponent.this.mSelectionRange.set(value, value);
                        SelectionComponent.this.mode = Mode.ADJUST_MIN;
                        break;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (e.isControlDown()) {
                    SelectionComponent.this.requestZoom(SelectionComponent.this.mSelectionRange.getMin(), SelectionComponent.this.mSelectionRange.getMax());
                }
                SelectionComponent.this.mode = Mode.OBSERVE;
            }
        });
        this.mHost.addMouseWheelListener(e -> {
            double anchor = this.mAxis.getValueAtPosition(e.getPoint().x);
            float zoomPercentage = 0.1f * (float)e.getWheelRotation();
            double delta = (double)zoomPercentage * this.mViewRange.getLength();
            double minDelta = delta * (anchor - this.mViewRange.getMin()) / this.mViewRange.getLength();
            double maxDelta = delta - minDelta;
            this.requestZoom(this.mViewRange.getMin() - minDelta, this.mViewRange.getMax() + maxDelta);
        });
    }

    private Point getMouseLocation() {
        Point mLoc = MouseInfo.getPointerInfo().getLocation();
        Point cLoc = this.getLocationOnScreen();
        int x = (int)(mLoc.getX() - cLoc.getX());
        int y = (int)(mLoc.getY() - cLoc.getY());
        return new Point(x, y);
    }

    private Mode getModeForMousePosition(Point mMousePosition) {
        if (this.getHandleAreaForValue(this.mSelectionRange.getMax()).contains(mMousePosition)) {
            return Mode.ADJUST_MAX;
        }
        if (this.getHandleAreaForValue(this.mSelectionRange.getMin()).contains(mMousePosition)) {
            return Mode.ADJUST_MIN;
        }
        if (this.getBetweenHandlesArea().contains(mMousePosition)) {
            this.saveMouseBlockOffset(mMousePosition);
            return Mode.MOVE;
        }
        return Mode.CREATE;
    }

    private void saveMouseBlockOffset(Point mMousePosition) {
        double value = this.mAxis.getValueAtPosition(mMousePosition.x);
        this.mSelectionBlockClickOffset = this.mSelectionRange.getMin() - value;
    }

    public void zoom(float percentage) {
        double zoomDelta = this.mViewRange.getLength() * (double)percentage;
        this.requestZoom(this.mViewRange.getMin() - zoomDelta, this.mViewRange.getMax() + zoomDelta);
    }

    public void resetZoom() {
        this.mViewRange.set(this.mDataRange.getMin(), this.mDataRange.getMax());
    }

    public void clear() {
        this.mSelectionRange.set(0.0, 0.0);
        this.mode = Mode.NO_SELECTION;
    }

    @Override
    public void reset() {
        super.reset();
        this.clear();
    }

    @Override
    protected void updateData() {
        if (!this.isShowing()) {
            return;
        }
        if (this.mZoomRequested) {
            if (this.mZoomMinTarget != this.mViewRange.getMin() || this.mZoomMaxTarget != this.mViewRange.getMax()) {
                this.mViewRange.setTarget(this.mZoomMinTarget, this.mZoomMaxTarget);
                this.mViewRange.lockValues();
            }
            this.mZoomRequested = false;
        }
        Point mousePosition = this.getMouseLocation();
        double valueAtCursor = this.mAxis.getValueAtPosition(mousePosition.x);
        valueAtCursor = this.mDataRange.clamp(valueAtCursor);
        this.mReportingContainer = null;
        this.mReportingData.clear();
        mousePosition = SwingUtilities.convertPoint(this, mousePosition, this.mHost);
        Component hoveredComponent = SwingUtilities.getDeepestComponentAt(this.mHost, mousePosition.x, mousePosition.y);
        if (hoveredComponent instanceof ReportingSeriesRenderer) {
            this.mReportingContainer = (ReportingSeriesRenderer)((Object)hoveredComponent);
            for (ReportingSeries series : this.mReportingContainer.getReportingSeries()) {
                Collection<ReportingSeries.ReportingData> reportingDataCollection = series.getFullReportingData((long)valueAtCursor);
                for (ReportingSeries.ReportingData data : reportingDataCollection) {
                    this.mReportingContainer.markData(data.timeStamp);
                }
                this.mReportingData.put(series, reportingDataCollection);
            }
        }
        if (this.mode == Mode.OBSERVE || this.mode == Mode.NO_SELECTION) {
            return;
        }
        if (valueAtCursor > this.mViewRange.getMax()) {
            this.mViewRange.setMax(valueAtCursor);
            this.mViewRange.lockValues();
        } else if (valueAtCursor < this.mViewRange.getMin()) {
            this.mViewRange.setMin(valueAtCursor);
            this.mViewRange.lockValues();
        }
        if (this.mode == Mode.ADJUST_MIN && valueAtCursor > this.mSelectionRange.getMax()) {
            this.mSelectionRange.flip();
            this.mode = Mode.ADJUST_MAX;
        } else if (this.mode == Mode.ADJUST_MAX && valueAtCursor < this.mSelectionRange.getMin()) {
            this.mSelectionRange.flip();
            this.mode = Mode.ADJUST_MIN;
        }
        switch (this.mode) {
            case CREATE: {
                break;
            }
            case ADJUST_MIN: {
                this.mSelectionRange.setMin(valueAtCursor);
                break;
            }
            case ADJUST_MAX: {
                this.mSelectionRange.setMax(valueAtCursor);
                break;
            }
            case MOVE: {
                double length = this.mSelectionRange.getLength();
                this.mSelectionRange.set(valueAtCursor + this.mSelectionBlockClickOffset, valueAtCursor + this.mSelectionBlockClickOffset + length);
                if (this.mSelectionRange.getMin() < this.mViewRange.getMin()) {
                    this.mSelectionRange.shift(this.mViewRange.getMin() - this.mSelectionRange.getMin());
                }
                if (!(this.mSelectionRange.getMax() > this.mViewRange.getMax())) break;
                this.mSelectionRange.shift(this.mViewRange.getMax() - this.mSelectionRange.getMax());
            }
        }
    }

    private void drawCursor(Point position) {
        int cursor = 0;
        if (this.getHandleAreaForValue(this.mSelectionRange.getMax()).contains(position) || this.getHandleAreaForValue(this.mSelectionRange.getMin()).contains(position)) {
            cursor = 13;
        } else if (this.getBetweenHandlesArea().contains(position)) {
            cursor = 12;
        }
        if (this.getTopLevelAncestor().getCursor().getType() != cursor) {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(cursor));
        }
    }

    private void drawOverlayInfo(Graphics2D g, Point position) {
        if (this.mReportingContainer == null) {
            return;
        }
        int ascent = this.mDefaultFontMetrics.getAscent();
        int labelColumnWidth = 0;
        int dataColumnWidth = 0;
        int overlayHeight = 10 + ascent + 5;
        String containerName = this.mReportingContainer.getContainerName();
        if (containerName != null) {
            labelColumnWidth = this.mDefaultFontMetrics.stringWidth(containerName);
            overlayHeight += ascent + 5;
        }
        ArrayDeque<Integer> dataWidthArray = new ArrayDeque<Integer>();
        for (ReportingSeries series : this.mReportingData.keySet()) {
            int labelWidth = this.mDefaultFontMetrics.stringWidth(series.getLabel());
            labelColumnWidth = Math.max(labelColumnWidth, labelWidth);
            for (ReportingSeries.ReportingData data : this.mReportingData.get(series)) {
                int dataWidth = this.mDefaultFontMetrics.stringWidth(data.formattedYData);
                dataColumnWidth = Math.max(dataColumnWidth, dataWidth);
                dataWidthArray.add(dataWidth);
                overlayHeight += ascent + 5;
            }
        }
        int overlayWidth = Math.max(200, 20 + labelColumnWidth + dataColumnWidth);
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, overlayWidth, overlayHeight);
        g.translate(position.x + 10, position.y + 10);
        g.translate(2, 2);
        g.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        g.fill(rect);
        g.translate(-2, -2);
        g.setColor(AdtUiUtils.OVERLAY_INFO_BACKGROUND);
        g.fill(rect);
        g.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        g.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        int textHeight = 5;
        if (containerName != null) {
            g.drawString(containerName, 5, textHeight += ascent);
            textHeight += 5;
        }
        for (ReportingSeries series : this.mReportingData.keySet()) {
            for (ReportingSeries.ReportingData data : this.mReportingData.get(series)) {
                g.drawString(series.getLabel(), 5, textHeight += ascent);
                g.drawString(data.formattedYData, overlayWidth - 5 - (Integer)dataWidthArray.remove(), textHeight);
                textHeight += 5;
            }
        }
        g.drawLine(0, textHeight, overlayWidth, textHeight);
        g.drawString(OVERLAY_DRILL_DOWN_MESSAGE, 5, textHeight += 5 + ascent);
        g.translate(-(position.x + 10), -(position.y + 10));
    }

    @Override
    protected void draw(Graphics2D g) {
        Dimension dim = this.getSize();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point mousePosition = this.getMouseLocation();
        if (this.mode != Mode.NO_SELECTION) {
            this.drawCursor(mousePosition);
            g.setColor(AdtUiUtils.SELECTION_BACKGROUND);
            float startXPos = this.mAxis.getPositionAtValue(this.mSelectionRange.getMin());
            float endXPos = this.mAxis.getPositionAtValue(this.mSelectionRange.getMax());
            Rectangle2D.Float rect = new Rectangle2D.Float(startXPos, 0.0f, endXPos - startXPos, dim.height);
            g.fill(rect);
            g.setColor(AdtUiUtils.SELECTION_FOREGROUND);
            Path2D.Float path = new Path2D.Float();
            path.moveTo(startXPos, 0.0f);
            path.lineTo(startXPos, dim.height);
            path.moveTo(endXPos, dim.height);
            path.lineTo(endXPos, 0.0f);
            g.draw(path);
            this.drawHandleAtValue(g, this.mSelectionRange.getMin());
            this.drawHandleAtValue(g, this.mSelectionRange.getMax());
        }
        this.drawOverlayInfo(g, mousePosition);
    }

    private void requestZoom(double minTarget, double maxTarget) {
        this.mZoomMinTarget = Math.max(this.mDataRange.getMin(), minTarget);
        this.mZoomMaxTarget = Math.min(this.mDataRange.getMax(), maxTarget);
        this.mZoomRequested = true;
    }

    private void drawHandleAtValue(Graphics2D g, double value) {
        g.setPaint(AdtUiUtils.SELECTION_HANDLE);
        RoundRectangle2D.Double handle = this.getHandleAreaForValue(value);
        g.fill(handle);
    }

    private RoundRectangle2D.Double getHandleAreaForValue(double value) {
        float x = this.mAxis.getPositionAtValue(value);
        return new RoundRectangle2D.Double((double)x - HANDLE_DIM.getWidth() / 2.0, 0.0, HANDLE_DIM.getWidth(), HANDLE_DIM.getHeight(), 5.0, 5.0);
    }

    private Rectangle2D.Double getBetweenHandlesArea() {
        double startXPos = this.mAxis.getPositionAtValue(this.mSelectionRange.getMin());
        double endXPos = this.mAxis.getPositionAtValue(this.mSelectionRange.getMax());
        return new Rectangle2D.Double(startXPos - HANDLE_DIM.getWidth() / 2.0, 0.0, endXPos - startXPos, HANDLE_DIM.getHeight());
    }

    private static enum Mode {
        NO_SELECTION,
        OBSERVE,
        CREATE,
        MOVE,
        ADJUST_MIN,
        ADJUST_MAX;

    }
}

