/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.RotatedLabel;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.intellij.ui.components.JBLabel;
import gnu.trove.TFloatArrayList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class AxisComponent
extends AnimatedComponent {
    private static final int MAJOR_MARKER_LENGTH = 12;
    private static final int MINOR_MARKER_LENGTH = 3;
    private static final int MARKER_LABEL_MARGIN = 2;
    private static final int LABEL_BOUNDS_OFFSET = 5;
    private static final int MAXIMUM_LABEL_WIDTH = 50;
    private AxisComponent mParentAxis;
    @NotNull
    private final Range mRange;
    @NotNull
    private final Range mGlobalRange;
    @NotNull
    private final JLabel mLabel;
    @NotNull
    private final FontMetrics mMetrics;
    @NotNull
    private final AxisOrientation mOrientation;
    private final int mStartMargin;
    private final int mEndMargin;
    private boolean mShowMinMax;
    private boolean mClampToMajorTicks;
    @NotNull
    private final BaseAxisFormatter mFormatter;
    private double mCurrentMaxValue;
    private double mCurrentMinValue;
    private int mAxisLength;
    private float mMajorInterval;
    private float mMinorInterval;
    private float mMajorScale;
    private float mMinorScale;
    private float mMajorNumTicksTarget;
    private double mFirstMarkerValue;
    private final TFloatArrayList mMajorMarkerPositions;
    private final TFloatArrayList mMinorMarkerPositions;

    public AxisComponent(@NotNull Range range, @NotNull Range globalRange, @NotNull String label, @NotNull AxisOrientation orientation, int startMargin, int endMargin, boolean showMinMax, @NotNull BaseAxisFormatter formatter) {
        this.mRange = range;
        this.mGlobalRange = globalRange;
        this.mOrientation = orientation;
        this.mShowMinMax = showMinMax;
        this.mFormatter = formatter;
        this.mMajorMarkerPositions = new TFloatArrayList();
        this.mMinorMarkerPositions = new TFloatArrayList();
        this.mStartMargin = startMargin;
        this.mEndMargin = endMargin;
        this.mMetrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
        switch (this.mOrientation) {
            case LEFT: 
            case RIGHT: {
                this.mLabel = new RotatedLabel(label);
                this.mLabel.setSize(this.mMetrics.getHeight(), this.mMetrics.stringWidth(label));
                break;
            }
            default: {
                this.mLabel = new JBLabel(label);
                this.mLabel.setSize(this.mMetrics.stringWidth(label), this.mMetrics.getHeight());
            }
        }
        this.mLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT);
    }

    public void setClampToMajorTicks(boolean clamp) {
        this.mClampToMajorTicks = clamp;
    }

    public void setParentAxis(AxisComponent parent) {
        this.mParentAxis = parent;
    }

    @NotNull
    public AxisOrientation getOrientation() {
        return this.mOrientation;
    }

    @NotNull
    public TFloatArrayList getMajorMarkerPositions() {
        return this.mMajorMarkerPositions;
    }

    public void setLabelVisible(boolean isVisible) {
        this.mLabel.setVisible(isVisible);
    }

    public float getPositionAtValue(double value) {
        float offset = (float)((double)this.mMinorScale * (value - this.mCurrentMinValue) / (double)this.mMinorInterval);
        float ret = 0.0f;
        switch (this.mOrientation) {
            case LEFT: 
            case RIGHT: {
                ret = 1.0f - offset;
                break;
            }
            case TOP: 
            case BOTTOM: {
                ret = offset;
            }
        }
        return ret * (float)this.mAxisLength;
    }

    public double getValueAtPosition(int position) {
        float offset = 0.0f;
        switch (this.mOrientation) {
            case LEFT: 
            case RIGHT: {
                offset = this.mAxisLength - position;
                break;
            }
            case TOP: 
            case BOTTOM: {
                offset = position;
            }
        }
        float normalizedOffset = offset / (float)this.mAxisLength;
        return this.mCurrentMinValue + (double)(this.mMinorInterval * normalizedOffset / this.mMinorScale);
    }

    @NotNull
    public String getFormattedValueAtPosition(int position) {
        return this.mFormatter.getFormattedString(this.mGlobalRange.getLength(), this.getValueAtPosition(position));
    }

    @Override
    protected void updateData() {
        double clampedMaxTarget;
        double maxTarget = this.mRange.getMaxTarget();
        double rangeTarget = this.mRange.getTargetLength();
        if (this.mParentAxis == null) {
            int majorInterval = this.mFormatter.getMajorInterval(rangeTarget);
            this.mMajorNumTicksTarget = this.mClampToMajorTicks ? (float)Math.ceil(maxTarget / (double)majorInterval) : (float)(maxTarget / (double)majorInterval);
            clampedMaxTarget = this.mMajorNumTicksTarget * (float)majorInterval;
        } else {
            int majorInterval = this.mFormatter.getInterval(rangeTarget, (int)Math.floor(this.mParentAxis.mMajorNumTicksTarget));
            clampedMaxTarget = this.mParentAxis.mMajorNumTicksTarget * (float)majorInterval;
        }
        this.mRange.setMaxTarget(clampedMaxTarget);
    }

    @Override
    public void postAnimate() {
        this.mMajorMarkerPositions.reset();
        this.mMinorMarkerPositions.reset();
        this.mCurrentMinValue = this.mRange.getMin();
        this.mCurrentMaxValue = this.mRange.getMax();
        double range = this.mRange.getLength();
        this.mMajorInterval = this.mFormatter.getMajorInterval(range);
        this.mMinorInterval = this.mFormatter.getMinorInterval(this.mMajorInterval);
        this.mMajorScale = (float)((double)this.mMajorInterval / range);
        this.mMinorScale = (float)((double)this.mMinorInterval / range);
        this.mFirstMarkerValue = Math.floor(this.mCurrentMinValue / (double)this.mMajorInterval) * (double)this.mMajorInterval;
        float firstMarkerOffset = (float)((double)this.mMinorScale * (this.mFirstMarkerValue - this.mCurrentMinValue) / (double)this.mMinorInterval);
        int numMarkers = (int)Math.floor((this.mCurrentMaxValue - this.mFirstMarkerValue) / (double)this.mMinorInterval) + 1;
        int numMinorPerMajor = (int)(this.mMajorInterval / this.mMinorInterval);
        for (int i = 0; i < numMarkers; ++i) {
            float markerOffset = firstMarkerOffset + (float)i * this.mMinorScale;
            if (i % numMinorPerMajor == 0) {
                this.mMajorMarkerPositions.add(markerOffset);
                continue;
            }
            this.mMinorMarkerPositions.add(markerOffset);
        }
    }

    @Override
    protected void draw(Graphics2D g) {
        Point startPoint = new Point();
        Point endPoint = new Point();
        Point labelPoint = new Point();
        Dimension dimension = this.getSize();
        switch (this.mOrientation) {
            case LEFT: {
                startPoint.x = endPoint.x = dimension.width - 1;
                startPoint.y = dimension.height - this.mStartMargin - 1;
                endPoint.y = this.mEndMargin;
                this.mAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = 0;
                labelPoint.y = endPoint.y;
                break;
            }
            case BOTTOM: {
                startPoint.x = this.mStartMargin;
                endPoint.x = dimension.width - this.mEndMargin - 1;
                endPoint.y = 0;
                startPoint.y = 0;
                this.mAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = startPoint.x;
                labelPoint.y = this.getHeight() - (this.mMetrics.getMaxAscent() + this.mMetrics.getMaxDescent());
                break;
            }
            case RIGHT: {
                endPoint.x = 0;
                startPoint.x = 0;
                startPoint.y = dimension.height - this.mStartMargin - 1;
                endPoint.y = this.mEndMargin;
                this.mAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = this.getWidth() - this.mMetrics.getMaxAdvance();
                labelPoint.y = endPoint.y;
                break;
            }
            case TOP: {
                startPoint.x = this.mStartMargin;
                endPoint.x = dimension.width - this.mEndMargin - 1;
                startPoint.y = endPoint.y = dimension.height - 1;
                this.mAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = 0;
                labelPoint.y = 0;
            }
        }
        if (this.mAxisLength > 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(AdtUiUtils.DEFAULT_BORDER_COLOR);
            g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            this.drawMarkers(g, startPoint);
            if (this.mLabel.isVisible()) {
                AffineTransform initialTransform = g.getTransform();
                g.translate(labelPoint.x, labelPoint.y);
                this.mLabel.paint(g);
                g.setTransform(initialTransform);
            }
        }
    }

    private void drawMarkers(Graphics2D g2d, Point origin) {
        float scaledPosition;
        int i;
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        if (this.mShowMinMax) {
            this.drawMarkerLabel(g2d, 5.0f, origin, this.mCurrentMinValue, true);
            this.drawMarkerLabel(g2d, this.mAxisLength - 5, origin, this.mCurrentMaxValue, true);
        }
        Line2D.Float line = new Line2D.Float();
        for (i = 0; i < this.mMinorMarkerPositions.size(); ++i) {
            if (!(this.mMinorMarkerPositions.get(i) >= 0.0f)) continue;
            scaledPosition = this.mMinorMarkerPositions.get(i) * (float)this.mAxisLength;
            this.drawMarkerLine(g2d, line, scaledPosition, origin, false);
        }
        for (i = 0; i < this.mMajorMarkerPositions.size(); ++i) {
            if (!(this.mMajorMarkerPositions.get(i) >= 0.0f)) continue;
            scaledPosition = this.mMajorMarkerPositions.get(i) * (float)this.mAxisLength;
            this.drawMarkerLine(g2d, line, scaledPosition, origin, true);
            double markerValue = this.mFirstMarkerValue + (double)((float)i * this.mMajorInterval);
            this.drawMarkerLabel(g2d, scaledPosition, origin, markerValue, !this.mShowMinMax);
        }
    }

    private void drawMarkerLine(Graphics2D g2d, Line2D.Float line, float markerOffset, Point origin, boolean isMajor) {
        float markerStartX = 0.0f;
        float markerStartY = 0.0f;
        float markerEndX = 0.0f;
        float markerEndY = 0.0f;
        int markerLength = isMajor ? 12 : 3;
        switch (this.mOrientation) {
            case LEFT: {
                markerStartX = origin.x - markerLength;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = origin.x;
                break;
            }
            case RIGHT: {
                markerStartX = 0.0f;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = markerLength;
                break;
            }
            case TOP: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = origin.y - markerLength;
                markerEndY = origin.y;
                break;
            }
            case BOTTOM: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = 0.0f;
                markerEndY = markerLength;
            }
        }
        line.setLine(markerStartX, markerStartY, markerEndX, markerEndY);
        g2d.setColor(AdtUiUtils.DEFAULT_BORDER_COLOR);
        g2d.draw(line);
    }

    private void drawMarkerLabel(Graphics2D g2d, float markerOffset, Point origin, double markerValue, boolean isMinMax) {
        float reserved;
        float labelY;
        float labelX;
        String formattedValue = this.mFormatter.getFormattedString(this.mGlobalRange.getLength(), markerValue);
        int stringAscent = this.mMetrics.getAscent();
        int stringLength = this.mMetrics.stringWidth(formattedValue);
        switch (this.mOrientation) {
            case LEFT: {
                labelX = origin.x - 12 - 2 - stringLength;
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case RIGHT: {
                labelX = 14.0f;
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case TOP: {
                labelX = (float)origin.x + markerOffset + 2.0f;
                labelY = origin.y - 3;
                reserved = stringLength;
                break;
            }
            case BOTTOM: {
                labelX = (float)origin.x + markerOffset + 2.0f;
                labelY = 3 + stringAscent;
                reserved = stringLength;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected orientation: " + (Object)((Object)this.mOrientation)));
            }
        }
        if (isMinMax || markerOffset - reserved > 0.0f && markerOffset + reserved < (float)this.mAxisLength) {
            g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            g2d.drawString(formattedValue, labelX, labelY);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 64;
        int height = this.mStartMargin + this.mEndMargin;
        return this.mOrientation == AxisOrientation.LEFT || this.mOrientation == AxisOrientation.RIGHT ? new Dimension(width, height) : new Dimension(height, width);
    }

    public static enum AxisOrientation {
        LEFT,
        BOTTOM,
        RIGHT,
        TOP;

    }
}

