/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskState;

public class TaskStateInternal
implements TaskState {
    private boolean executing;
    private boolean executed;
    private boolean didWork;
    private Throwable failure;
    private String description;
    private String skippedMessage;
    private boolean skipped;
    private boolean upToDate;

    public TaskStateInternal(String description) {
        this.description = description;
    }

    public boolean getDidWork() {
        return this.didWork;
    }

    public void setDidWork(boolean didWork) {
        this.didWork = didWork;
    }

    public boolean getExecuted() {
        return this.executed;
    }

    public void executed() {
        this.executed = true;
    }

    public boolean isConfigurable() {
        return !this.executed && !this.executing;
    }

    public void executed(Throwable failure) {
        assert (this.failure == null);
        this.executed = true;
        this.failure = failure;
    }

    public void skipped(String skipMessage) {
        this.executed = true;
        this.skipped = true;
        this.skippedMessage = skipMessage;
    }

    public void upToDate() {
        this.skipped("UP-TO-DATE");
        this.upToDate = true;
    }

    public boolean getExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void rethrowFailure() {
        if (this.failure == null) {
            return;
        }
        if (this.failure instanceof RuntimeException) {
            throw (RuntimeException)this.failure;
        }
        if (this.failure instanceof Error) {
            throw (Error)this.failure;
        }
        throw new GradleException(String.format("%s failed with an exception.", StringUtils.capitalize((String)this.description)), this.failure);
    }

    public boolean getSkipped() {
        return this.skipped;
    }

    public String getSkipMessage() {
        return this.skippedMessage;
    }

    public boolean getUpToDate() {
        return this.upToDate;
    }
}

