/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.plugins.DefaultExtraPropertiesExtension;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.plugins.ExtensionsStorage;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.GetPropertyResult;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.SetPropertyResult;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConvention
implements Convention,
ExtensionContainerInternal {
    private final Map<String, Object> plugins = new LinkedHashMap<String, Object>();
    private final ExtensionsDynamicObject extensionsDynamicObject = new ExtensionsDynamicObject();
    private final ExtensionsStorage extensionsStorage = new ExtensionsStorage();
    private final ExtraPropertiesExtension extraProperties = new DefaultExtraPropertiesExtension();
    private final Instantiator instantiator;

    public DefaultConvention() {
        this(null);
    }

    public DefaultConvention(Instantiator instantiator) {
        this.instantiator = instantiator;
        this.add("ext", this.extraProperties);
    }

    @Override
    public Map<String, Object> getPlugins() {
        return this.plugins;
    }

    @Override
    public DynamicObject getExtensionsAsDynamicObject() {
        return this.extensionsDynamicObject;
    }

    private Instantiator getInstantiator() {
        if (this.instantiator == null) {
            throw new GradleException("request for DefaultConvention.instantiator when the object was constructed without a convention");
        }
        return this.instantiator;
    }

    @Override
    public <T> T getPlugin(Class<T> type) {
        T value = this.findPlugin(type);
        if (value == null) {
            throw new IllegalStateException(String.format("Could not find any convention object of type %s.", type.getSimpleName()));
        }
        return value;
    }

    @Override
    public <T> T findPlugin(Class<T> type) throws IllegalStateException {
        ArrayList<T> values = new ArrayList<T>();
        for (Object object : this.plugins.values()) {
            if (!type.isInstance(object)) continue;
            values.add(type.cast(object));
        }
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple convention objects of type %s.", type.getSimpleName()));
        }
        return (T)values.get(0);
    }

    @Override
    public void add(String name, Object extension) {
        if (extension instanceof Class) {
            this.create(name, (Class)extension, new Object[0]);
        } else {
            this.extensionsStorage.add(name, extension);
        }
    }

    @Override
    public <T> T create(String name, Class<T> type, Object ... constructionArguments) {
        Object instance = this.getInstantiator().newInstance(type, constructionArguments);
        this.add(name, instance);
        return (T)instance;
    }

    @Override
    public ExtraPropertiesExtension getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public <T> T getByType(Class<T> type) {
        return this.extensionsStorage.getByType(type);
    }

    @Override
    public <T> T findByType(Class<T> type) {
        return this.extensionsStorage.findByType(type);
    }

    @Override
    public Object getByName(String name) {
        return this.extensionsStorage.getByName(name);
    }

    @Override
    public Object findByName(String name) {
        return this.extensionsStorage.findByName(name);
    }

    @Override
    public <T> void configure(Class<T> type, Action<? super T> action) {
        this.extensionsStorage.configureExtension(type, action);
    }

    @Override
    public Map<String, Object> getAsMap() {
        return this.extensionsStorage.getAsMap();
    }

    public Object propertyMissing(String name) {
        return this.getByName(name);
    }

    public void propertyMissing(String name, Object value) {
        this.extensionsStorage.checkExtensionIsNotReassigned(name);
        this.add(name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensionsDynamicObject
    extends AbstractDynamicObject {
        private ExtensionsDynamicObject() {
        }

        @Override
        public String getDisplayName() {
            return "extensions";
        }

        @Override
        public boolean hasProperty(String name) {
            if (DefaultConvention.this.extensionsStorage.hasExtension(name)) {
                return true;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                if (!new BeanDynamicObject(object).hasProperty(name)) continue;
                return true;
            }
            return false;
        }

        public Map<String, Object> getProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ArrayList reverseOrder = new ArrayList(DefaultConvention.this.plugins.values());
            Collections.reverse(reverseOrder);
            for (Object object : reverseOrder) {
                properties.putAll(new BeanDynamicObject(object).getProperties());
            }
            properties.putAll(DefaultConvention.this.extensionsStorage.getAsMap());
            return properties;
        }

        @Override
        public void getProperty(String name, GetPropertyResult result) {
            Object extension = DefaultConvention.this.extensionsStorage.findByName(name);
            if (extension != null) {
                result.result(extension);
                return;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = new BeanDynamicObject(object).withNotImplementsMissing();
                dynamicObject.getProperty(name, result);
                if (!result.isFound()) continue;
                return;
            }
        }

        public Object propertyMissing(String name) {
            return this.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value, SetPropertyResult result) {
            DefaultConvention.this.extensionsStorage.checkExtensionIsNotReassigned(name);
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = new BeanDynamicObject(object).withNotImplementsMissing();
                dynamicObject.setProperty(name, value, result);
                if (!result.isFound()) continue;
                return;
            }
        }

        public void propertyMissing(String name, Object value) {
            this.setProperty(name, value);
        }

        @Override
        public void invokeMethod(String name, InvokeMethodResult result, Object ... args) {
            if (DefaultConvention.this.extensionsStorage.isConfigureExtensionMethod(name, args)) {
                result.result(DefaultConvention.this.extensionsStorage.configureExtension(name, args));
                return;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = new BeanDynamicObject(object).withNotImplementsMissing();
                dynamicObject.invokeMethod(name, result, args);
                if (!result.isFound()) continue;
                return;
            }
        }

        public Object methodMissing(String name, Object args) {
            return this.invokeMethod(name, (Object[])args);
        }

        @Override
        public boolean hasMethod(String name, Object ... args) {
            if (DefaultConvention.this.extensionsStorage.isConfigureExtensionMethod(name, args)) {
                return true;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = new BeanDynamicObject(object);
                if (!dynamicObject.hasMethod(name, args)) continue;
                return true;
            }
            return false;
        }
    }
}

