/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStringUtil {
    private XmlStringUtil() {
    }

    @NotNull
    public static String wrapInCDATA(@NotNull String str) {
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = StringUtil.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        return sb.toString();
    }

    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    @NotNull
    public static String wrapInHtml(@NotNull CharSequence result) {
        return "<html>" + result + "</html>";
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        return StringUtil.startsWithIgnoreCase(tooltip, "<html>") && StringUtil.endsWithIgnoreCase(tooltip, "</html>");
    }

    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        toolTip = StringUtil.trimStart(toolTip, "<html>");
        toolTip = StringUtil.trimStart(toolTip, "<body>");
        toolTip = StringUtil.trimEnd(toolTip, "</html>");
        toolTip = StringUtil.trimEnd(toolTip, "</body>");
        return toolTip;
    }

    @NotNull
    public static String convertToHtmlContent(@NotNull String text) {
        return XmlStringUtil.isWrappedInHtml(text) ? XmlStringUtil.stripHtml(text) : XmlStringUtil.escapeString(text);
    }

    @NotNull
    public static String escapeIllegalXmlChars(@NotNull String text) {
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.codePointAt(i);
            if (Character.isSupplementaryCodePoint(c)) {
                ++i;
            }
            if (c != 35 && Verifier.isXMLCharacter((int)c)) continue;
            if (b == null) {
                b = new StringBuilder(text.length() + 5);
            }
            b.append(text, lastPos, i).append('#');
            if (c != 35) {
                b.append(Integer.toHexString(c));
            }
            b.append('#');
            lastPos = i + 1;
        }
        return b == null ? text : b.append(text, lastPos, text.length()).toString();
    }

    @NotNull
    public static String unescapeIllegalXmlChars(@NotNull String text) {
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int charCode;
            int numberEnd;
            char c = text.charAt(i);
            if (c != '#' || (numberEnd = text.indexOf(35, i + 1)) <= 0) continue;
            try {
                charCode = numberEnd == i + 1 ? 35 : Integer.parseInt(text.substring(i + 1, numberEnd), 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (b == null) {
                b = new StringBuilder(text.length());
            }
            b.append(text, lastPos, i);
            b.append((char)charCode);
            i = numberEnd;
            lastPos = i + 1;
        }
        return b == null ? text : b.append(text, lastPos, text.length()).toString();
    }
}

