/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagBinding
extends BasePrimitiveBinding
implements MultiNodeBinding {
    private final String myTextIfEmpty;

    public TagBinding(@NotNull MutableAccessor accessor, @NotNull Tag tagAnnotation) {
        super(accessor, tagAnnotation.value(), null);
        this.myTextIfEmpty = tagAnnotation.textIfEmpty();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        Element serialized = new Element(this.myName);
        if (value == null) {
            return serialized;
        }
        if (this.myBinding == null) {
            serialized.addContent((Content)new Text(XmlSerializerImpl.convertToString(value)));
        } else {
            Object node = this.myBinding.serialize(value, serialized, filter);
            if (node != null && node != serialized) {
                JDOMUtil.addContent(serialized, node);
            }
        }
        return serialized;
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<Element> elements) {
        ArrayList<Element> children;
        if (elements.size() == 1) {
            children = elements.get(0).getChildren();
        } else {
            String name = elements.get(0).getName();
            children = new ArrayList<Element>();
            for (Element element : elements) {
                assert (element.getName().equals(name));
                children.addAll(element.getChildren());
            }
        }
        this.deserialize(context, children);
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        if (this.myBinding == null) {
            String value = XmlSerializerImpl.getTextValue(element, this.myTextIfEmpty);
            XmlSerializerImpl.doSet(context, value, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.deserialize(context, element.getChildren());
        }
        return context;
    }

    private void deserialize(Object o, @NotNull List<Element> children) {
        assert (this.myBinding != null);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(o, children.get(0), null);
        } else {
            this.myAccessor.set(o, Binding.deserializeList(this.myBinding, this.myAccessor.read(o), children));
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element node) {
        return node.getName().equals(this.myName);
    }
}

