/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import gnu.trove.TObjectFloatHashMap;
import java.util.LinkedHashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class SmartSerializer {
    private LinkedHashSet<String> mySerializedAccessorNameTracker;
    private TObjectFloatHashMap<String> myOrderedBindings;
    private final SerializationFilter mySerializationFilter;

    public SmartSerializer(boolean trackSerializedNames, boolean useSkipEmptySerializationFilter) {
        this.mySerializedAccessorNameTracker = trackSerializedNames ? new LinkedHashSet() : null;
        this.mySerializationFilter = useSkipEmptySerializationFilter ? new SkipEmptySerializationFilter(){

            @Override
            protected ThreeState accepts(@NotNull String name, @NotNull Object beanValue) {
                return SmartSerializer.this.mySerializedAccessorNameTracker != null && SmartSerializer.this.mySerializedAccessorNameTracker.contains(name) ? ThreeState.YES : ThreeState.UNSURE;
            }
        } : new SkipDefaultValuesSerializationFilters(){

            @Override
            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (SmartSerializer.this.mySerializedAccessorNameTracker != null && SmartSerializer.this.mySerializedAccessorNameTracker.contains(accessor.getName())) {
                    return true;
                }
                return super.accepts(accessor, bean);
            }
        };
    }

    public SmartSerializer() {
        this(true, false);
    }

    @NotNull
    public static SmartSerializer skipEmptySerializer() {
        return new SmartSerializer(true, true);
    }

    public void readExternal(@NotNull Object bean, @NotNull Element element) {
        if (this.mySerializedAccessorNameTracker != null) {
            this.mySerializedAccessorNameTracker.clear();
            this.myOrderedBindings = null;
        }
        BeanBinding beanBinding = SmartSerializer.getBinding(bean);
        beanBinding.deserializeInto(bean, element, this.mySerializedAccessorNameTracker);
        if (this.mySerializedAccessorNameTracker != null) {
            this.myOrderedBindings = beanBinding.computeBindingWeights(this.mySerializedAccessorNameTracker);
        }
    }

    public void writeExternal(@NotNull Object bean, @NotNull Element element) {
        this.writeExternal(bean, element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Object bean, @NotNull Element element, boolean preserveCompatibility) {
        BeanBinding binding = SmartSerializer.getBinding(bean);
        if (preserveCompatibility && this.myOrderedBindings != null) {
            binding.sortBindings(this.myOrderedBindings);
        }
        if (preserveCompatibility || this.mySerializedAccessorNameTracker == null) {
            binding.serializeInto(bean, element, this.mySerializationFilter);
        } else {
            LinkedHashSet<String> oldTracker = this.mySerializedAccessorNameTracker;
            try {
                this.mySerializedAccessorNameTracker = null;
                binding.serializeInto(bean, element, this.mySerializationFilter);
            }
            finally {
                this.mySerializedAccessorNameTracker = oldTracker;
            }
        }
    }

    @NotNull
    private static BeanBinding getBinding(@NotNull Object bean) {
        return (BeanBinding)XmlSerializerImpl.getBinding(bean.getClass());
    }
}

