/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    public OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        Element targetElement = new Element(this.myTagName);
        if (!StringUtil.isEmpty(this.myNameAttribute)) {
            targetElement.setAttribute(this.myNameAttribute, this.myName);
        }
        if (value == null) {
            return targetElement;
        }
        if (this.myConverter == null) {
            if (this.myBinding == null) {
                targetElement.setAttribute(this.myValueAttribute, XmlSerializerImpl.convertToString(value));
            } else if (this.myBinding instanceof BeanBinding && this.myValueAttribute.isEmpty()) {
                ((BeanBinding)this.myBinding).serializeInto(value, targetElement, filter);
            } else {
                Object node = this.myBinding.serialize(value, targetElement, filter);
                if (node != null && targetElement != node) {
                    JDOMUtil.addContent(targetElement, node);
                }
            }
        } else {
            targetElement.setAttribute(this.myValueAttribute, this.myConverter.toString(value));
        }
        return targetElement;
    }

    @Override
    public Object deserialize(Object context, @NotNull Element element) {
        Attribute valueAttribute = element.getAttribute(this.myValueAttribute);
        if (valueAttribute == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context, this.myBinding.deserialize(context, element));
            } else {
                List children = element.getChildren();
                if (children.isEmpty()) {
                    this.myAccessor.set(context, null);
                } else {
                    assert (this.myBinding != null);
                    this.myAccessor.set(context, Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children));
                }
            }
        } else if (this.myConverter == null) {
            XmlSerializerImpl.doSet(context, valueAttribute.getValue(), this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.myAccessor.set(context, this.myConverter.fromString(valueAttribute.getValue()));
        }
        return context;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (!element.getName().equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

