/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MainBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import gnu.trove.THashMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapBinding
extends Binding
implements MultiNodeBinding,
MainBinding {
    private static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
    };
    private final MapAnnotation myMapAnnotation;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;

    public MapBinding(@NotNull MutableAccessor accessor) {
        super(accessor);
        this.myMapAnnotation = accessor.getAnnotation(MapAnnotation.class);
    }

    @Override
    public void init(@NotNull Type originalType) {
        ParameterizedType type = (ParameterizedType)originalType;
        Type[] typeArguments = type.getActualTypeArguments();
        this.keyClass = XmlSerializerImpl.typeToClass(typeArguments[0]);
        this.valueClass = XmlSerializerImpl.typeToClass(typeArguments[1]);
        this.keyBinding = XmlSerializerImpl.getClassBinding(this.keyClass, typeArguments[0], null);
        this.valueBinding = XmlSerializerImpl.getClassBinding(this.valueClass, typeArguments[1], null);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        Element serialized;
        Element element = serialized = this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag() ? new Element("map") : (Element)context;
        assert (serialized != null);
        Map map = (Map)o;
        Object[] keys = ArrayUtil.toObjectArray(map.keySet());
        if (!(map instanceof TreeMap) && (this.myMapAnnotation == null || this.myMapAnnotation.sortBeforeSave())) {
            Arrays.sort(keys, KEY_COMPARATOR);
        }
        for (Object k : keys) {
            Element entry = new Element(this.getEntryAttributeName());
            serialized.addContent(entry);
            this.serializeKeyOrValue(entry, this.getKeyAttributeName(), k, this.keyBinding, filter);
            this.serializeKeyOrValue(entry, this.getValueAttributeName(), map.get(k), this.valueBinding, filter);
        }
        return serialized == context ? null : serialized;
    }

    private String getEntryAttributeName() {
        return this.myMapAnnotation == null ? "entry" : this.myMapAnnotation.entryTagName();
    }

    private String getKeyAttributeName() {
        return this.myMapAnnotation == null ? "key" : this.myMapAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        return this.myMapAnnotation == null ? "value" : this.myMapAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<Element> elements) {
        List childNodes;
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            assert (elements.size() == 1);
            childNodes = elements.get(0).getChildren();
        } else {
            childNodes = elements;
        }
        return this.deserialize(context, childNodes);
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            return this.deserialize(context, element.getChildren());
        }
        return this.deserialize(context, Collections.singletonList(element));
    }

    @Nullable
    private Map deserialize(@Nullable Object context, @NotNull List<Element> childNodes) {
        Map map = (Map)context;
        if (map != null) {
            map.clear();
        }
        for (Element childNode : childNodes) {
            if (!childNode.getName().equals(this.getEntryAttributeName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + childNode);
                continue;
            }
            if (map == null) {
                map = new THashMap();
            }
            map.put(this.deserializeKeyOrValue(childNode, this.getKeyAttributeName(), context, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(childNode, this.getValueAttributeName(), context, this.valueBinding, this.valueClass));
        }
        return map;
    }

    private void serializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, @Nullable Object value, @Nullable Binding binding, @NotNull SerializationFilter filter) {
        if (value == null) {
            return;
        }
        if (binding == null) {
            entry.setAttribute(attributeName, XmlSerializerImpl.convertToString(value));
        } else {
            Object serialized = binding.serialize(value, entry, filter);
            if (serialized != null) {
                if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
                    entry.addContent((Content)serialized);
                } else {
                    Element container = new Element(attributeName);
                    container.addContent((Content)serialized);
                    entry.addContent(container);
                }
            }
        }
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        Attribute attribute = entry.getAttribute(attributeName);
        if (attribute != null) {
            return XmlSerializerImpl.convert(attribute.getValue(), valueClass);
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
            assert (binding != null);
            for (Element element : entry.getChildren()) {
                if (!binding.isBoundTo(element)) continue;
                return binding.deserialize(context, element);
            }
        } else {
            List children;
            Element entryChild = entry.getChild(attributeName);
            List list = children = entryChild == null ? Collections.emptyList() : entryChild.getChildren();
            if (children.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, context, children);
        }
        return null;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundWithTag()) {
            return this.myMapAnnotation.entryTagName().equals(element.getName());
        }
        return element.getName().equals("map");
    }
}

