/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
extends Binding
implements MultiNodeBinding {
    private final String myTagName;

    public JDOMElementBinding(@NotNull MutableAccessor accessor) {
        super(accessor);
        Tag tag = this.myAccessor.getAnnotation(Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        String tagName = tag.value();
        if (StringUtil.isEmpty(tagName)) {
            tagName = this.myAccessor.getName();
        }
        this.myTagName = tagName;
    }

    @Override
    public Object serialize(@NotNull Object o, Object context, @NotNull SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        if (value instanceof Element) {
            Element targetElement = ((Element)value).clone();
            assert (targetElement != null);
            targetElement.setName(this.myTagName);
            return targetElement;
        }
        if (value instanceof Element[]) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element element : (Element[])value) {
                result.add(element.clone().setName(this.myTagName));
            }
            return result;
        }
        throw new XmlSerializationException("org.jdom.Element expected but " + value + " found");
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<Element> elements) {
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.set(context, elements.toArray(new Element[elements.size()]));
        } else {
            this.myAccessor.set(context, elements.get(0));
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        this.myAccessor.set(context, element);
        return context;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.myTagName);
    }
}

