/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MainBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.TObjectFloatHashMap;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanBinding
extends Binding
implements MainBinding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    private Binding[] myBindings;
    final Class<?> myBeanClass;
    ThreeState compareByFields = ThreeState.UNSURE;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        super(accessor);
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public synchronized void init(@NotNull Type originalType) {
        assert (this.myBindings == null);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            this.myBindings[i] = BeanBinding.createBinding(accessors.get(i));
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        return this.serializeInto(o, context == null ? null : new Element(this.myTagName), filter);
    }

    public Element serialize(@NotNull Object object, boolean createElementIfEmpty, @NotNull SerializationFilter filter) {
        return this.serializeInto(object, createElementIfEmpty ? new Element(this.myTagName) : null, filter);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o, @Nullable Element element, @NotNull SerializationFilter filter) {
        for (Binding binding : this.myBindings) {
            Object node;
            MutableAccessor accessor = binding.getAccessor();
            if (!(filter instanceof SkipDefaultsSerializationFilter) ? !filter.accepts(accessor, o) : ((SkipDefaultsSerializationFilter)filter).equal(binding, o)) continue;
            Property property = accessor.getAnnotation(Property.class);
            if (property != null && property.filter() != SerializationFilter.class && !ReflectionUtil.newInstance(property.filter()).accepts(accessor, o)) continue;
            if (element == null) {
                element = new Element(this.myTagName);
            }
            if ((node = binding.serialize(o, element, filter)) == null) continue;
            if (node instanceof org.jdom.Attribute) {
                element.setAttribute((org.jdom.Attribute)node);
                continue;
            }
            JDOMUtil.addContent(element, node);
        }
        return element;
    }

    @Override
    public Object deserialize(Object context, @NotNull Element element) {
        Object instance = ReflectionUtil.newInstance(this.myBeanClass);
        this.deserializeInto(instance, element, null);
        return instance;
    }

    boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter) {
        for (Binding binding : this.myBindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TObjectFloatHashMap<String> computeBindingWeights(@NotNull LinkedHashSet<String> accessorNameTracker) {
        TObjectFloatHashMap weights = new TObjectFloatHashMap(accessorNameTracker.size());
        float weight = 0.0f;
        float step = (float)this.myBindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put((Object)name, weight);
            weight += step;
        }
        weight = 0.0f;
        for (Binding binding : this.myBindings) {
            String name = binding.getAccessor().getName();
            if (!weights.containsKey((Object)name)) {
                weights.put((Object)name, weight);
            }
            weight += 1.0f;
        }
        return weights;
    }

    public void sortBindings(final @NotNull TObjectFloatHashMap<String> weights) {
        Arrays.sort(this.myBindings, new Comparator<Binding>(){

            @Override
            public int compare(@NotNull Binding o1, @NotNull Binding o2) {
                String n1 = o1.getAccessor().getName();
                String n2 = o2.getAccessor().getName();
                float w1 = weights.get((Object)n1);
                float w2 = weights.get((Object)n2);
                return (int)(w1 - w2);
            }
        });
    }

    public void deserializeInto(@NotNull Object result, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        block0: for (org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserialize(result, child);
                continue block2;
            }
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result, (List)data.get(binding));
            }
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.myTagName);
    }

    private static String getTagName(Class<?> aClass) {
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            return name;
        }
        String name = aClass.getSimpleName();
        return name.isEmpty() ? aClass.getSuperclass().getSimpleName() : name;
    }

    private static String getTagNameFromAnnotation(Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        List<MutableAccessor> accessors = ourAccessorCache.get(aClass);
        if (accessors != null) {
            return accessors;
        }
        accessors = ContainerUtil.newArrayList();
        Map<Object, Object> nameToAccessors = aClass != Rectangle.class ? BeanBinding.collectPropertyAccessors(aClass, accessors) : Collections.emptyMap();
        int propertyAccessorCount = accessors.size();
        BeanBinding.collectFieldAccessors(aClass, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = accessors.get(j).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!accessors.get(i).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        ourAccessorCache.put(aClass, accessors);
        return accessors;
    }

    @NotNull
    private static Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<MutableAccessor> accessors) {
        TreeMap<String, Couple<Method>> candidates = ContainerUtilRt.newTreeMap();
        for (Method method : aClass.getMethods()) {
            Pair<String, Boolean> propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || ((String)propertyData.first).equals("class") || method.getParameterTypes().length != ((Boolean)propertyData.second != false ? 1 : 0)) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.first);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if (((Boolean)propertyData.second != false ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = Couple.of((Boolean)propertyData.second != false ? (Method)candidate.first : method, (Boolean)propertyData.second != false ? method : (Method)candidate.second);
            candidates.put((String)propertyData.first, (Couple<Method>)candidate);
        }
        Iterator iterator = candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry candidate = iterator.next();
            Couple methods = (Couple)candidate.getValue();
            if (methods.first != null && methods.second != null && ((Method)methods.first).getReturnType().equals(((Method)methods.second).getParameterTypes()[0]) && ((Method)methods.first).getAnnotation(Transient.class) == null && ((Method)methods.second).getAnnotation(Transient.class) == null) {
                accessors.add(new PropertyAccessor((String)candidate.getKey(), ((Method)methods.first).getReturnType(), (Method)methods.first, (Method)methods.second));
                continue;
            }
            iterator.remove();
        }
        return candidates;
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass, @NotNull List<MutableAccessor> accessors) {
        Class<?> currentClass = aClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || field.getAnnotation(OptionTag.class) == null && field.getAnnotation(Tag.class) == null && field.getAnnotation(Attribute.class) == null && field.getAnnotation(Property.class) == null && field.getAnnotation(Text.class) == null && field.getAnnotation(CollectionBean.class) == null && field.getAnnotation(MapAnnotation.class) == null && field.getAnnotation(AbstractCollection.class) == null && (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(field.getType()) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static Pair<String, Boolean> getPropertyData(@NotNull String methodName) {
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3, methodName.length());
            isSetter = true;
        }
        return part.isEmpty() ? null : Pair.create(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor) {
        Binding binding = XmlSerializerImpl.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            return binding;
        }
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            return new AttributeBinding(accessor, attribute);
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            return new TagBinding(accessor, tag);
        }
        Text text = accessor.getAnnotation(Text.class);
        if (text != null) {
            return new TextBinding(accessor);
        }
        if (binding instanceof CompactCollectionBinding) {
            return new AccessorBindingWrapper(accessor, binding);
        }
        boolean surroundWithTag = true;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
        }
        if (!surroundWithTag) {
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding);
        }
        return new OptionTagBinding(accessor, accessor.getAnnotation(OptionTag.class));
    }
}

