/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttributeBinding
extends BasePrimitiveBinding {
    private final Class<?> valueClass;

    public AttributeBinding(@NotNull MutableAccessor accessor, @NotNull Attribute attribute) {
        super(accessor, attribute.value(), attribute.converter());
        this.valueClass = XmlSerializerImpl.typeToClass(accessor.getGenericType());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        String stringValue = this.myConverter == null ? XmlSerializerImpl.convertToString(value) : this.myConverter.toString(value);
        return new org.jdom.Attribute(this.myName, stringValue);
    }

    void set(@NotNull Object host, @NotNull String value) {
        if (this.myConverter == null) {
            XmlSerializerImpl.doSet(host, value, this.myAccessor, this.valueClass);
        } else {
            this.myAccessor.set(host, this.myConverter.fromString(value));
        }
    }

    public String toString() {
        return "AttributeBinding[" + this.myName + "]";
    }
}

