/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class AccessBridgeUtil {
    private static final ThreadLocal<Status> myStatus = new ThreadLocal<Status>(){

        @Override
        protected Status initialValue() {
            Status result = new Status();
            result.myIsWorkerThread = this._isWorkerThread();
            return result;
        }

        private boolean _isWorkerThread() {
            StackTraceElement[] stack;
            if (!SystemInfo.isWindows) {
                return false;
            }
            if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
                return false;
            }
            for (StackTraceElement e : stack = Thread.currentThread().getStackTrace()) {
                if (!StringUtil.equals(e.getClassName(), "com.sun.java.accessibility.AccessBridge") || !StringUtil.equals(e.getMethodName(), "runDLL")) continue;
                return true;
            }
            return false;
        }
    };

    public static boolean isWorkerThread() {
        return AccessBridgeUtil.myStatus.get().myIsWorkerThread;
    }

    public static <T> T invokeAndWait(@NotNull Computable<T> computable) {
        assert (AccessBridgeUtil.isWorkerThread());
        return UIUtil.invokeAndWaitIfNeeded(computable);
    }

    private static class Status {
        public boolean myIsWorkerThread;

        private Status() {
        }
    }
}

