/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import org.jetbrains.annotations.NotNull;

public class ImageUtil {
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static int getRealWidth(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getWidth(null);
    }

    public static int getRealHeight(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getHeight(null);
    }

    public static Image filter(Image image, ImageFilter filter) {
        if (image == null || filter == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter));
    }
}

