/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridBag
extends GridBagConstraints {
    private int myDefaultAnchor;
    @NotNull
    private final TIntIntHashMap myDefaultColumnAnchors;
    private int myDefaultFill;
    @NotNull
    private final TIntIntHashMap myDefaultColumnFills;
    private double myDefaultWeightX;
    @NotNull
    private final TIntDoubleHashMap myDefaultColumnWeightsX;
    private double myDefaultWeightY;
    @NotNull
    private final TIntDoubleHashMap myDefaultColumnWeightsY;
    private int myDefaultPaddingX;
    @NotNull
    private final TIntIntHashMap myDefaultColumnPaddingsX;
    private int myDefaultPaddingY;
    @NotNull
    private final TIntIntHashMap myDefaultColumnPaddingsY;
    @Nullable
    private Insets myDefaultInsets;
    @NotNull
    private final TIntObjectHashMap<Insets> myDefaultColumnInsets;

    public GridBag() {
        this.myDefaultAnchor = this.anchor;
        this.myDefaultColumnAnchors = new TIntIntHashMap();
        this.myDefaultFill = this.fill;
        this.myDefaultColumnFills = new TIntIntHashMap();
        this.myDefaultWeightX = this.weightx;
        this.myDefaultColumnWeightsX = new TIntDoubleHashMap();
        this.myDefaultWeightY = this.weighty;
        this.myDefaultColumnWeightsY = new TIntDoubleHashMap();
        this.myDefaultPaddingX = this.ipadx;
        this.myDefaultColumnPaddingsX = new TIntIntHashMap();
        this.myDefaultPaddingY = this.ipady;
        this.myDefaultColumnPaddingsY = new TIntIntHashMap();
        this.myDefaultInsets = this.insets;
        this.myDefaultColumnInsets = new TIntObjectHashMap();
        this.gridy = -1;
        this.gridx = -1;
    }

    @NotNull
    public GridBag nextLine() {
        ++this.gridy;
        this.gridx = -1;
        return this.reset();
    }

    @NotNull
    public GridBag next() {
        ++this.gridx;
        return this.reset();
    }

    public int getLine() {
        return this.gridy;
    }

    @NotNull
    public GridBag setLine(int line) {
        this.gridy = line;
        return this;
    }

    public int getColumn() {
        return this.gridx;
    }

    @NotNull
    public GridBag setColumn(int cell) {
        this.gridx = cell;
        return this;
    }

    @NotNull
    public GridBag reset() {
        this.gridheight = 1;
        this.gridwidth = 1;
        int column = this.gridx;
        this.anchor(this.getDefaultAnchor(column));
        this.fill = this.getDefaultFill(column);
        this.weightx(this.getDefaultWeightX(column));
        this.weighty(this.getDefaultWeightY(column));
        this.padx(this.getDefaultPaddingX(column));
        this.pady(this.getDefaultPaddingY(column));
        this.insets(this.getDefaultInsets(column));
        return this;
    }

    @NotNull
    public GridBag anchor(int anchor) {
        this.anchor = anchor;
        return this;
    }

    @NotNull
    public GridBag fillCell() {
        this.fill = 1;
        return this;
    }

    @NotNull
    public GridBag fillCellHorizontally() {
        this.fill = 2;
        return this;
    }

    @NotNull
    public GridBag fillCellVertically() {
        this.fill = 3;
        return this;
    }

    public GridBag fillCellNone() {
        this.fill = 0;
        return this;
    }

    @NotNull
    public GridBag weightx(double weight) {
        this.weightx = weight;
        return this;
    }

    @NotNull
    public GridBag weighty(double weight) {
        this.weighty = weight;
        return this;
    }

    @NotNull
    public GridBag coverLine() {
        this.gridwidth = 0;
        return this;
    }

    @NotNull
    public GridBag coverLine(int cells) {
        this.gridwidth = cells;
        return this;
    }

    @NotNull
    public GridBag coverColumn() {
        this.gridheight = 0;
        return this;
    }

    @NotNull
    public GridBag coverColumn(int cells) {
        this.gridheight = cells;
        return this;
    }

    @NotNull
    public GridBag padx(int padding) {
        this.ipadx = padding;
        return this;
    }

    @NotNull
    public GridBag pady(int padding) {
        this.ipady = padding;
        return this;
    }

    @NotNull
    public GridBag insets(int top, int left, int bottom, int right) {
        return this.insets(new Insets(top, left, bottom, right));
    }

    @NotNull
    public GridBag insets(@Nullable Insets insets) {
        if (insets != null && (insets.top < 0 || insets.bottom < 0 || insets.left < 0 || insets.right < 0)) {
            Insets def = this.getDefaultInsets(this.gridx);
            insets = (Insets)insets.clone();
            if (insets.top < 0) {
                int n = insets.top = def == null ? 0 : def.top;
            }
            if (insets.left < 0) {
                int n = insets.left = def == null ? 0 : def.left;
            }
            if (insets.bottom < 0) {
                int n = insets.bottom = def == null ? 0 : def.bottom;
            }
            if (insets.right < 0) {
                insets.right = def == null ? 0 : def.right;
            }
        }
        this.insets = insets;
        return this;
    }

    public int getDefaultAnchor() {
        return this.myDefaultAnchor;
    }

    @NotNull
    public GridBag setDefaultAnchor(int anchor) {
        this.myDefaultAnchor = anchor;
        return this;
    }

    public int getDefaultAnchor(int column) {
        return this.myDefaultColumnAnchors.containsKey(column) ? this.myDefaultColumnAnchors.get(column) : this.getDefaultAnchor();
    }

    @NotNull
    public GridBag setDefaultAnchor(int column, int anchor) {
        if (anchor == -1) {
            this.myDefaultColumnAnchors.remove(column);
        } else {
            this.myDefaultColumnAnchors.put(column, anchor);
        }
        return this;
    }

    public int getDefaultFill() {
        return this.myDefaultFill;
    }

    @NotNull
    public GridBag setDefaultFill(int fill) {
        this.myDefaultFill = fill;
        return this;
    }

    public int getDefaultFill(int column) {
        return this.myDefaultColumnFills.containsKey(column) ? this.myDefaultColumnFills.get(column) : this.getDefaultFill();
    }

    @NotNull
    public GridBag setDefaultFill(int column, int fill) {
        if (fill == -1) {
            this.myDefaultColumnFills.remove(column);
        } else {
            this.myDefaultColumnFills.put(column, fill);
        }
        return this;
    }

    public double getDefaultWeightX() {
        return this.myDefaultWeightX;
    }

    @NotNull
    public GridBag setDefaultWeightX(double weight) {
        this.myDefaultWeightX = weight;
        return this;
    }

    public double getDefaultWeightX(int column) {
        return this.myDefaultColumnWeightsX.containsKey(column) ? this.myDefaultColumnWeightsX.get(column) : this.getDefaultWeightX();
    }

    @NotNull
    public GridBag setDefaultWeightX(int column, double weight) {
        if (weight == -1.0) {
            this.myDefaultColumnWeightsX.remove(column);
        } else {
            this.myDefaultColumnWeightsX.put(column, weight);
        }
        return this;
    }

    public double getDefaultWeightY() {
        return this.myDefaultWeightY;
    }

    @NotNull
    public GridBag setDefaultWeightY(double weight) {
        this.myDefaultWeightY = weight;
        return this;
    }

    public double getDefaultWeightY(int column) {
        return this.myDefaultColumnWeightsY.containsKey(column) ? this.myDefaultColumnWeightsY.get(column) : this.getDefaultWeightY();
    }

    @NotNull
    public GridBag setDefaultWeightY(int column, double weight) {
        if (weight == -1.0) {
            this.myDefaultColumnWeightsY.remove(column);
        } else {
            this.myDefaultColumnWeightsY.put(column, weight);
        }
        return this;
    }

    public int getDefaultPaddingX() {
        return this.myDefaultPaddingX;
    }

    @NotNull
    public GridBag setDefaultPaddingX(int padding) {
        this.myDefaultPaddingX = padding;
        return this;
    }

    public int getDefaultPaddingX(int column) {
        return this.myDefaultColumnPaddingsX.containsKey(column) ? this.myDefaultColumnPaddingsX.get(column) : this.getDefaultPaddingX();
    }

    @NotNull
    public GridBag setDefaultPaddingX(int column, int padding) {
        if (padding == -1) {
            this.myDefaultColumnPaddingsX.remove(column);
        } else {
            this.myDefaultColumnPaddingsX.put(column, padding);
        }
        return this;
    }

    public int getDefaultPaddingY() {
        return this.myDefaultPaddingY;
    }

    @NotNull
    public GridBag setDefaultPaddingY(int padding) {
        this.myDefaultPaddingY = padding;
        return this;
    }

    public int getDefaultPaddingY(int column) {
        return this.myDefaultColumnPaddingsY.containsKey(column) ? this.myDefaultColumnPaddingsY.get(column) : this.getDefaultPaddingY();
    }

    @NotNull
    public GridBag setDefaultPaddingY(int column, int padding) {
        if (padding == -1) {
            this.myDefaultColumnPaddingsY.remove(column);
        } else {
            this.myDefaultColumnPaddingsY.put(column, padding);
        }
        return this;
    }

    @Nullable
    public Insets getDefaultInsets() {
        return this.myDefaultInsets;
    }

    @NotNull
    public GridBag setDefaultInsets(int top, int left, int bottom, int right) {
        return this.setDefaultInsets(new Insets(top, left, bottom, right));
    }

    public GridBag setDefaultInsets(@Nullable Insets insets) {
        this.myDefaultInsets = insets;
        return this;
    }

    @Nullable
    public Insets getDefaultInsets(int column) {
        return this.myDefaultColumnInsets.containsKey(column) ? (Insets)this.myDefaultColumnInsets.get(column) : this.getDefaultInsets();
    }

    @NotNull
    public GridBag setDefaultInsets(int column, int top, int left, int bottom, int right) {
        return this.setDefaultInsets(column, new Insets(top, left, bottom, right));
    }

    @NotNull
    public GridBag setDefaultInsets(int column, @Nullable Insets insets) {
        if (insets == null) {
            this.myDefaultColumnInsets.remove(column);
        } else {
            this.myDefaultColumnInsets.put(column, (Object)insets);
        }
        return this;
    }
}

