/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableCharSequence
implements CharSequence {
    public static CharSequence asImmutable(@NotNull CharSequence cs) {
        return ImmutableCharSequence.isImmutable(cs) ? cs : cs.toString();
    }

    public static boolean isImmutable(@NotNull CharSequence cs) {
        if (cs instanceof ImmutableCharSequence) {
            return true;
        }
        if (cs instanceof CharSequenceSubSequence) {
            return ImmutableCharSequence.isImmutable(((CharSequenceSubSequence)cs).getBaseSequence());
        }
        return false;
    }
}

