/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import org.jetbrains.annotations.NotNull;

public class CharArrayCharSequence
implements CharSequenceBackedByArray,
CharSequenceWithStringHash {
    protected final char[] myChars;
    protected final int myStart;
    protected final int myEnd;
    private int hash;

    public CharArrayCharSequence(char ... chars) {
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(@NotNull char[] chars, int start, int end) {
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.myEnd - this.myStart);
    }

    @Override
    @NotNull
    public char[] getChars() {
        if (this.myStart == 0) {
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        System.arraycopy(this.myChars, this.myStart, chars, 0, this.length());
        return chars;
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        CharSequence anotherString;
        int n;
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof CharSequence && (n = this.myEnd - this.myStart) == (anotherString = (CharSequence)anObject).length()) {
            for (int i = 0; i < n; ++i) {
                if (this.myChars[this.myStart + i] == anotherString.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int readCharsTo(int start, char[] cbuf, int off, int len) {
        int readChars = Math.min(len, this.length() - start);
        if (readChars <= 0) {
            return -1;
        }
        System.arraycopy(this.myChars, this.myStart + start, cbuf, off, readChars);
        return readChars;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }
}

