/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

public class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private int hash;
    private final byte[] myChars;

    private ByteArrayCharSequence(@NotNull byte[] chars) {
        this.myChars = chars;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public final int length() {
        return this.myChars.length;
    }

    @Override
    public final char charAt(int index) {
        return (char)this.myChars[index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharSequenceSubSequence(this, start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return StringFactory.createShared(CharArrayUtil.fromSequence(this, 0, this.length()));
    }

    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull String name) {
        return ByteArrayCharSequence.convertToBytesIfAsciiString((CharSequence)name);
    }

    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull CharSequence name) {
        int length = name.length();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0080') {
                return new String(name.toString());
            }
            bytes[i] = (byte)c;
        }
        return new ByteArrayCharSequence(bytes);
    }
}

