/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusFactory {
    private static final AtomicReference<Impl> ourImpl = new AtomicReference<Impl>(Impl.DEFAULT);

    private MessageBusFactory() {
    }

    @NotNull
    public static MessageBus newMessageBus(@NotNull Object owner) {
        return ourImpl.get().newMessageBus(owner);
    }

    @NotNull
    public static MessageBus newMessageBus(@NotNull Object owner, @Nullable MessageBus parentBus) {
        return ourImpl.get().newMessageBus(owner, parentBus);
    }

    public static void setImpl(@NotNull Impl impl) {
        ourImpl.set(impl);
    }

    public static interface Impl {
        public static final Impl DEFAULT = new Impl(){

            @Override
            @NotNull
            public MessageBus newMessageBus(@NotNull Object owner) {
                return new MessageBusImpl.RootBus(owner);
            }

            @Override
            @NotNull
            public MessageBus newMessageBus(@NotNull Object owner, @Nullable MessageBus parentBus) {
                return parentBus == null ? this.newMessageBus(owner) : new MessageBusImpl(owner, parentBus);
            }
        };

        @NotNull
        public MessageBus newMessageBus(@NotNull Object var1);

        @NotNull
        public MessageBus newMessageBus(@NotNull Object var1, @Nullable MessageBus var2);
    }
}

