/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.EventListener;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);

    private HeavyProcessLatch() {
    }

    @Deprecated
    public void processStarted() {
        this.processStarted("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AccessToken processStarted(final @NotNull String operationName) {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.add(operationName);
        }
        this.myEventDispatcher.getMulticaster().processStarted();
        return new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
    }

    @Deprecated
    public void processFinished() {
        this.processFinished("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinished(@NotNull String operationName) {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.remove(operationName);
        }
        this.myEventDispatcher.getMulticaster().processFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return !this.myHeavyProcesses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunningOperationName() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return this.myHeavyProcesses.isEmpty() ? null : this.myHeavyProcesses.iterator().next();
        }
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull HeavyProcessListener listener) {
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

