/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public abstract class BinaryOutputReader
extends BaseDataReader {
    @NotNull
    private final InputStream myStream;
    @NotNull
    private final byte[] myBuffer = new byte[8192];

    public BinaryOutputReader(@NotNull InputStream stream, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy) {
        super(sleepingPolicy);
        this.myStream = stream;
    }

    @Override
    protected boolean readAvailable() throws IOException {
        int n;
        byte[] buffer = this.myBuffer;
        boolean read = false;
        while (this.myStream.available() > 0 && (n = this.myStream.read(buffer)) > 0) {
            read = true;
            this.onBinaryAvailable(buffer, n);
        }
        return read;
    }

    protected abstract void onBinaryAvailable(@NotNull byte[] var1, int var2);

    @Override
    protected void close() throws IOException {
        this.myStream.close();
    }
}

