/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.StripedLockConcurrentHashMap;
import com.intellij.util.containers.StripedReentrantLocks;
import gnu.trove.TObjectHashingStrategy;
import java.util.ConcurrentModificationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
class _CHMSegment<K, V> {
    private static final StripedReentrantLocks STRIPED_REENTRANT_LOCKS = StripedReentrantLocks.getInstance();
    private final byte lockIndex = (byte)STRIPED_REENTRANT_LOCKS.allocateLockIndex();
    volatile int count;
    volatile HashEntry[] table;
    private static final float loadFactor = 0.75f;
    private volatile boolean modificationBlocked;

    private void lock() {
        STRIPED_REENTRANT_LOCKS.lock(this.lockIndex & 0xFF);
        if (this.modificationBlocked) {
            throw new ConcurrentModificationException();
        }
    }

    private void unlock() {
        STRIPED_REENTRANT_LOCKS.unlock(this.lockIndex & 0xFF);
    }

    private int threshold() {
        return (int)((float)this.table.length * 0.75f);
    }

    _CHMSegment(int initialCapacity) {
        this.setTable(new HashEntry[initialCapacity]);
    }

    public void blockModification() {
        try {
            this.lock();
            this.modificationBlocked = true;
        }
        finally {
            this.unlock();
        }
    }

    void setTable(HashEntry[] newTable) {
        this.table = newTable;
    }

    HashEntry<K, V> getFirst(int hash) {
        HashEntry[] tab = this.table;
        return tab[hash & tab.length - 1];
    }

    V readValueUnderLock(HashEntry<K, V> e) {
        try {
            this.lock();
            Object v = e.value;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    V get(K key, int hash) {
        if (this.count != 0) {
            HashEntry<K, V> e = this.getFirst(hash);
            while (e != null) {
                if (e.hash == hash && this.getHashingStrategy().equals(key, e.key)) {
                    Object v = e.value;
                    if (v != null) {
                        return v;
                    }
                    return this.readValueUnderLock(e);
                }
                e = e.next;
            }
        }
        return null;
    }

    boolean containsKey(K key, int hash) {
        if (this.count != 0) {
            HashEntry<K, V> e = this.getFirst(hash);
            while (e != null) {
                if (e.hash == hash && this.getHashingStrategy().equals(key, e.key)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsValue(Object value) {
        if (this.count != 0) {
            for (HashEntry hashEntry : this.table) {
                void var5_5;
                while (var5_5 != null) {
                    Object v = var5_5.value;
                    if (v == null) {
                        v = this.readValueUnderLock((HashEntry<K, V>)var5_5);
                    }
                    if (value.equals(v)) {
                        return true;
                    }
                    HashEntry hashEntry2 = var5_5.next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replace(@NotNull K key, int hash, @NotNull V oldValue, @NotNull V newValue) {
        try {
            this.lock();
            HashEntry<K, V> e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && this.getHashingStrategy().equals(key, e.key))) {
                e = e.next;
            }
            boolean replaced = false;
            if (e != null && oldValue.equals(e.value)) {
                replaced = true;
                e.value = newValue;
            }
            boolean bl = replaced;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V replace(@NotNull K key, int hash, @NotNull V newValue) {
        try {
            this.lock();
            HashEntry<K, V> e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && this.getHashingStrategy().equals(key, e.key))) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                oldValue = e.value;
                e.value = newValue;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V put(@NotNull K key, int hash, @NotNull V value, boolean onlyIfAbsent) {
        try {
            V oldValue;
            HashEntry first;
            this.lock();
            int c = this.count;
            if (c++ > this.threshold()) {
                this.rehash();
            }
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && this.getHashingStrategy().equals(key, e.key))) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                if (!onlyIfAbsent) {
                    e.value = value;
                }
            } else {
                oldValue = null;
                tab[index] = new HashEntry(key, hash, first, value);
                this.count = c;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    void rehash() {
        HashEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return;
        }
        HashEntry[] newTable = new HashEntry[oldCapacity << 1];
        int sizeMask = newTable.length - 1;
        for (int i = 0; i < oldCapacity; ++i) {
            int k;
            HashEntry e = oldTable[i];
            if (e == null) continue;
            HashEntry next = e.next;
            int idx = e.hash & sizeMask;
            if (next == null) {
                newTable[idx] = e;
                continue;
            }
            HashEntry lastRun = e;
            int lastIdx = idx;
            HashEntry last = next;
            while (last != null) {
                k = last.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            HashEntry p = e;
            while (p != lastRun) {
                k = p.hash & sizeMask;
                HashEntry n = newTable[k];
                newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                p = p.next;
            }
        }
        this.setTable(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V remove(@NotNull K key, int hash, @Nullable(value="null means don't care") Object value) {
        try {
            HashEntry first;
            this.lock();
            int c = this.count - 1;
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && this.getHashingStrategy().equals(key, e.key))) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                Object v = e.value;
                if (value == null || value.equals(v)) {
                    oldValue = v;
                    HashEntry newFirst = e.next;
                    HashEntry p = first;
                    while (p != e) {
                        newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    this.count = c;
                }
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        if (this.count != 0) {
            try {
                this.lock();
                HashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = null;
                }
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }

    protected TObjectHashingStrategy<K> getHashingStrategy() {
        return StripedLockConcurrentHashMap.CanonicalHashingStrategy.getInstance();
    }

    static final class HashEntry<K, V> {
        @NotNull
        final K key;
        final int hash;
        @NotNull
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(@NotNull K key, int hash, HashEntry<K, V> next, @NotNull V value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }
}

