/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTraversal {
    private final String debugName;
    @NotNull
    public static final TreeTraversal GUIDED_TRAVERSAL = new TreeTraversal("GUIDED_TRAVERSAL"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new GuidedItImpl<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal PRE_ORDER_DFS = new TreeTraversal("PRE_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new PreOrderIt<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal POST_ORDER_DFS = new TreeTraversal("POST_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new PostOrderIt<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_DFS = new TreeTraversal("LEAVES_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new LeavesDfsIt<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal INTERLEAVED_DFS = new TreeTraversal("INTERLEAVED_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new InterleavedIt<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal PLAIN_BFS = new TreeTraversal("PLAIN_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new PlainBfsIt<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal TRACING_BFS = new TreeTraversal("TRACING_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new TracingBfsIt<T>(roots, tree);
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_BFS = new TreeTraversal("LEAVES_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            return new LeavesBfsIt<T>(roots, tree);
        }
    };

    protected TreeTraversal(@NotNull String debugName) {
        this.debugName = debugName;
    }

    @NotNull
    public <T> JBIterable<T> traversal(final @NotNull Iterable<? extends T> roots, final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        return new JBIterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return TreeTraversal.this.createIterator(roots, tree);
            }
        };
    }

    @NotNull
    public <T> JBIterable<T> traversal(@Nullable T root, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        return this.traversal((T)ContainerUtil.createMaybeSingletonList(root), tree);
    }

    @NotNull
    public <T> Function<T, JBIterable<T>> traversal(final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        return new Function<T, JBIterable<T>>(){

            @Override
            public JBIterable<T> fun(T t) {
                return TreeTraversal.this.traversal(t, tree);
            }
        };
    }

    @NotNull
    public abstract <T> It<T> createIterator(@NotNull Iterable<? extends T> var1, @NotNull Function<T, ? extends Iterable<? extends T>> var2);

    public String toString() {
        return this.debugName;
    }

    private static final class P2<T>
    extends P<T, P2<T>> {
        P2<T> next;
        P2<T> prev;

        private P2() {
        }

        static <T> P2<T> create(T node) {
            return P2.create(new P2<T>(), node);
        }

        static <T> P2<T> create(Iterable<? extends T> it) {
            return P2.create(new P2<T>(), it);
        }

        P2<T> add(@NotNull P2<T> next) {
            next.next = this.next;
            next.prev = this;
            this.next = next;
            return next;
        }

        P2<T> remove() {
            P2<T> p = this.prev;
            P2<T> n = this.next;
            this.next = null;
            this.prev = null;
            if (p != null) {
                p.next = n;
            }
            if (n != null) {
                n.prev = p;
            }
            return p;
        }

        public String toString() {
            int h = 0;
            int t = 0;
            P2<T> p = this.prev;
            while (p != null) {
                ++h;
                p = p.prev;
            }
            p = this.next;
            while (p != null) {
                ++t;
                p = p.next;
            }
            return h + " of " + (h + t + 1) + ": " + this.node;
        }
    }

    private static final class P1<T>
    extends P<T, P1<T>> {
        private P1() {
        }

        static <T> P1<T> create(T node) {
            return P1.create(new P1<T>(), node);
        }

        static <T> P1<T> create(Iterable<? extends T> it) {
            return P1.create(new P1<T>(), it);
        }

        P1<T> add(@NotNull P1<T> next) {
            next.parent = this;
            return next;
        }

        P1<T> addBefore(@NotNull P1<T> next) {
            next.parent = null;
            this.parent = next;
            return next;
        }

        P1<T> remove() {
            P1 p = (P1)this.parent;
            this.parent = null;
            return p;
        }

        public String toString() {
            int h = 0;
            P1 p = (P1)this.parent;
            while (p != null) {
                ++h;
                p = (P1)p.parent;
            }
            return h + ": " + this.node;
        }
    }

    private static class P<T, Self extends P<T, Self>> {
        T node;
        Iterable<? extends T> itle;
        Iterator<? extends T> it;
        boolean empty;
        Self parent;
        static final Function TO_NODE = new Function<P<?, ?>, Object>(){

            @Override
            public Object fun(P<?, ?> tp) {
                return tp.node;
            }
        };
        static final Function TO_PREV = new Function.Mono<P<?, ?>>(){

            @Override
            public P<?, ?> fun(P<?, ?> tp) {
                return tp.parent;
            }
        };

        private P() {
        }

        static <T, Self extends P<T, Self>> Self create(Self p, T node) {
            p.node = node;
            return p;
        }

        static <T, Self extends P<T, Self>> Self create(Self p, Iterable<? extends T> it) {
            p.itle = it;
            return p;
        }

        final Iterator<? extends T> iterator(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (this.it != null) {
                return this.it;
            }
            this.it = this.iterable(tree).iterator();
            this.empty = this.itle == null || !this.it.hasNext();
            return this.it;
        }

        final Iterable<? extends T> iterable(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            Iterable<? extends T> iterable;
            if (this.itle != null) {
                iterable = this.itle;
            } else {
                this.itle = tree.fun(this.node);
                iterable = JBIterable.from(this.itle);
            }
            return iterable;
        }

        static <T> Function<P<T, ?>, T> toNode() {
            return TO_NODE;
        }

        static <T> Function<P<T, ?>, P<T, ?>> toPrev() {
            return TO_PREV;
        }
    }

    private static final class GuidedItImpl<T>
    extends GuidedIt<T> {
        P1<T> first;
        P1<T> last;
        Consumer<GuidedIt<T>> guide;
        T curResult;

        GuidedItImpl(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            this.last = P1.create(roots);
            this.first = this.last;
        }

        @Override
        public GuidedIt<T> setGuide(Consumer<GuidedIt<T>> guide) {
            this.guide = guide;
            return this;
        }

        @Override
        public GuidedIt<T> queueNext(T child) {
            if (child != null) {
                this.last = this.last.add(P1.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> queueLast(T child) {
            if (child != null) {
                this.first = this.first.addBefore(P1.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> result(T node) {
            this.curResult = node;
            return this;
        }

        @Override
        public T nextImpl() {
            if (this.guide == null) {
                return (T)this.stop();
            }
            while (this.last != null) {
                P1<T> top = this.last;
                Iterator it = top.iterator(this.tree);
                boolean hasNext = it.hasNext();
                this.curResult = null;
                if (top.node != null || hasNext) {
                    this.curChild = hasNext ? it.next() : null;
                    this.curParent = top.node;
                    this.curChildren = top.itle;
                    this.curNoChildren = top.empty;
                    this.guide.consume(this);
                }
                if (!hasNext) {
                    this.last = this.last.remove();
                }
                if (this.curResult == null) continue;
                return this.curResult;
            }
            return (T)this.stop();
        }
    }

    private static final class TracingBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        P1<T> top;

        /*
         * Exception decompiling
         */
        TracingBfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                for (Object t : this.top.iterable(this.tree)) {
                    if (this.paths.containsKey(t)) continue;
                    this.queue.add(t);
                    this.paths.put(t, this.top.node);
                }
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(this.queue.remove());
            return (T)this.top.node;
        }

        @Override
        public T parent() {
            if (this.top == null) {
                throw new NoSuchElementException();
            }
            return this._transform(this.paths.get(this.top.node));
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            if (this.top == null) {
                throw new NoSuchElementException();
            }
            return this._transform(JBIterable.generate(this.top.node, Functions.fromMap(this.paths)));
        }
    }

    private static final class LeavesBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue = new ArrayDeque();

        LeavesBfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            JBIterable.from(roots).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                Iterator it;
                T result = this.queue.remove();
                Iterable children = (Iterable)this.tree.fun(result);
                Iterator iterator = it = children == null ? null : children.iterator();
                if (it == null || !it.hasNext()) {
                    return result;
                }
                while (it.hasNext()) {
                    this.queue.add(it.next());
                }
            }
            return (T)this.stop();
        }
    }

    private static final class PlainBfsIt<T>
    extends It<T> {
        final ArrayDeque<T> queue = new ArrayDeque();
        P1<T> top;

        PlainBfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            JBIterable.from(roots).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                JBIterable.from(this.top.iterable(this.tree)).addAllTo(this.queue);
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(this.queue.remove());
            return (T)this.top.node;
        }
    }

    private static final class InterleavedIt<T>
    extends DfsIt<T, P2<T>> {
        P2<T> cur;
        P2<T> max;

        InterleavedIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            this.last = P2.create(roots);
            this.cur = this.max = (P2)this.last;
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Iterator it;
                if (this.cur == null) {
                    this.cur = this.max;
                    this.max = this.max.next;
                }
                if ((it = this.cur.iterator(this.tree)).hasNext()) {
                    Object result = it.next();
                    this.last = ((P2)this.last).add(P2.create(result));
                    ((P2)this.last).parent = this.cur;
                    this.cur = this.cur.prev;
                    if (this.max == null) {
                        this.max = (P2)this.last;
                    }
                    return result;
                }
                if (this.cur == this.last) {
                    this.last = this.cur.prev;
                }
                this.cur = this.cur.remove();
            }
            return (T)this.stop();
        }
    }

    private static final class LeavesDfsIt<T>
    extends DfsIt<T, P1<T>> {
        LeavesDfsIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            this.last = P1.create(roots);
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                P1 top = (P1)this.last;
                if (top.iterator(this.tree).hasNext() && !top.empty) {
                    Object child = top.iterator(this.tree).next();
                    this.last = ((P1)this.last).add(P1.create(child));
                    continue;
                }
                this.last = ((P1)this.last).remove();
                if (!top.empty) continue;
                return (T)(this.last == null ? this.stop() : top.node);
            }
            return (T)this.stop();
        }
    }

    private static final class PostOrderIt<T>
    extends DfsIt<T, P1<T>> {
        PostOrderIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            for (T root : roots) {
                P1<T> p = P1.create(root);
                this.last = this.last == null ? p : ((P1)this.last).add(p);
            }
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Object result;
                Iterator it = ((P1)this.last).iterator(this.tree);
                if (it.hasNext()) {
                    result = it.next();
                    this.last = ((P1)this.last).add(P1.create(result));
                    continue;
                }
                result = ((P1)this.last).node;
                this.last = ((P1)this.last).remove();
                return result;
            }
            return (T)this.stop();
        }
    }

    private static final class PreOrderIt<T>
    extends DfsIt<T, P1<T>> {
        PreOrderIt(@NotNull Iterable<? extends T> roots, Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            this.last = P1.create(roots);
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Iterator it = ((P1)this.last).iterator(this.tree);
                if (it.hasNext()) {
                    Object result = it.next();
                    this.last = ((P1)this.last).add(P1.create(result));
                    return result;
                }
                this.last = ((P1)this.last).remove();
            }
            return (T)this.stop();
        }
    }

    private static abstract class DfsIt<T, H extends P<T, H>>
    extends TracingIt<T> {
        H last;

        protected DfsIt(Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        @Override
        @Nullable
        public T parent() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            Object p = ((P)this.last).parent;
            return p == null ? null : (((P)p).node == null ? null : this._transform(((P)p).node));
        }

        @Override
        @NotNull
        public JBIterable<T> backtrace() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            return this._transform(JBIterable.generate(this.last, P.toPrev()).transform(P.toNode()).filter(Condition.NOT_NULL));
        }
    }

    public static abstract class GuidedIt<T>
    extends It<T> {
        @Nullable
        public T curChild;
        @Nullable
        public T curParent;
        @Nullable
        public Iterable<? extends T> curChildren;
        public boolean curNoChildren;

        public abstract GuidedIt<T> setGuide(Consumer<GuidedIt<T>> var1);

        public abstract GuidedIt<T> queueNext(T var1);

        public abstract GuidedIt<T> result(T var1);

        public abstract GuidedIt<T> queueLast(T var1);

        protected GuidedIt(Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }
    }

    public static abstract class TracingIt<T>
    extends It<T> {
        @Nullable
        public T parent() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public JBIterable<T> backtrace() {
            throw new UnsupportedOperationException();
        }

        protected TracingIt(Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        protected JBIterable<T> _transform(JBIterable<?> original) {
            JBIterable<Object> result = original;
            for (Function function : this.getTransformations()) {
                result = result.transform(function);
            }
            return result;
        }

        protected T _transform(Object original) {
            Object result = original;
            for (Function function : this.getTransformations()) {
                result = function.fun(result);
            }
            return (T)result;
        }
    }

    public static abstract class It<T>
    extends JBIterator<T> {
        protected final Function<T, ? extends Iterable<? extends T>> tree;

        protected It(Function<T, ? extends Iterable<? extends T>> tree) {
            this.tree = tree;
        }
    }
}

