/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Iterable<E> myIterable;
    private static final JBIterable EMPTY = new JBIterable(){

        @Override
        public Iterator iterator() {
            return ContainerUtil.emptyIterator();
        }
    };

    protected JBIterable() {
        this.myIterable = this;
    }

    JBIterable(@NotNull Iterable<E> iterable) {
        this.myIterable = iterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null) {
            return JBIterable.empty();
        }
        if (iterable instanceof JBIterable) {
            return (JBIterable)iterable;
        }
        return new JBIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return this.myIterable.iterator();
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (first == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (first1 == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        return elements == null ? JBIterable.empty() : JBIterable.from(ContainerUtil.newArrayList(elements));
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator) {
        return JBIterable.of(Ref.create(iterator)).intercept(new Function<Iterator<Ref<Iterator<E>>>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<Ref<Iterator<E>>> iterator) {
                Ref ref = iterator.next();
                Iterator result = ref.get();
                if (result == null) {
                    throw new UnsupportedOperationException();
                }
                ref.set(null);
                return result;
            }
        });
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        return (T)this.iterator();
    }

    @NotNull
    public String toString() {
        return this.myIterable == this ? super.toString() : String.valueOf(this.myIterable);
    }

    public final int size() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).size();
        }
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index) {
        if (this.myIterable instanceof List) {
            return index >= ((List)this.myIterable).size() ? null : (E)((List)this.myIterable).get(index);
        }
        return this.skip(index).first();
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other) : JBIterable.of(this.myIterable, other).flatten(Functions.identity()));
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    @NotNull
    public final JBIterable<E> repeat(int count) {
        Function fun = Functions.identity();
        return JBIterable.generate(this, fun).take(count).flatten(fun);
    }

    @NotNull
    public final JBIterable<E> append(@NotNull E[] elements) {
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)Arrays.asList(elements));
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E e) {
        return e == null ? this : (this == EMPTY ? JBIterable.of(e) : this.append(Collections.singleton(e)));
    }

    @NotNull
    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).filter(Stateful.copy(condition));
            }
        });
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        return this.filter(Conditions.instanceOf(type));
    }

    @NotNull
    public final JBIterable<E> take(final int count) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).take(count);
            }
        });
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).takeWhile(Stateful.copy(condition));
            }
        });
    }

    @NotNull
    public final JBIterable<E> skip(final int count) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skip(count);
            }
        });
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        return this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).skipWhile(Stateful.copy(condition));
            }
        });
    }

    @NotNull
    public final <T> JBIterable<T> transform(final @NotNull Function<? super E, T> function) {
        return this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(Iterator<E> iterator) {
                return JBIterator.from(iterator).transform(Stateful.copy(function));
            }
        });
    }

    @NotNull
    public <T> JBIterable<T> flatten(final Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(final Iterator<E> iterator) {
                final Function fun = Stateful.copy(function);
                return new JBIterator<T>(){
                    Iterator<? extends T> cur;

                    @Override
                    public T nextImpl() {
                        if (this.cur != null && this.cur.hasNext()) {
                            return this.cur.next();
                        }
                        if (!iterator.hasNext()) {
                            return this.stop();
                        }
                        this.cur = ((Iterable)fun.fun(iterator.next())).iterator();
                        return this.skip();
                    }
                };
            }
        });
    }

    @NotNull
    public final <T, X extends Iterator<E>> JBIterable<T> intercept(final @NotNull Function<X, ? extends Iterator<T>> function) {
        if (this == EMPTY) {
            return JBIterable.empty();
        }
        final JBIterable thisIterable = this;
        return new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return (Iterator)function.fun(thisIterable.iterator());
            }
        };
    }

    @Nullable
    public final E first() {
        Iterator<E> iterator = this.myIterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E last() {
        if (this.myIterable instanceof List) {
            return (E)ContainerUtil.getLastItem((List)this.myIterable);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        E cur = null;
        while (iterator.hasNext()) {
            cur = iterator.next();
        }
        return cur;
    }

    public final boolean isEmpty() {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).isEmpty();
        }
        return !this.myIterable.iterator().hasNext();
    }

    @NotNull
    public final List<E> toList() {
        return Collections.unmodifiableList(ContainerUtil.newArrayList(this.myIterable));
    }

    @NotNull
    public final Set<E> toSet() {
        return Collections.unmodifiableSet(ContainerUtil.newLinkedHashSet(this.myIterable));
    }

    @NotNull
    public final <V> Map<E, V> toMap(Convertor<E, V> valueFunction) {
        return Collections.unmodifiableMap(ContainerUtil.newMapFromKeys(this.iterator(), valueFunction));
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        return collection;
    }

    public static abstract class StatefulTransform<S, T>
    extends Stateful<StatefulTransform>
    implements Function<S, T> {
    }

    public static abstract class StatefulFilter<T>
    extends Stateful<StatefulFilter>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (!(o instanceof Stateful)) {
                return o;
            }
            return (T)((Stateful)o).clone();
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

