/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.LinkedHashMap;
import com.intellij.util.containers.LinkedHashSet;
import com.intellij.util.containers.Stack;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtilRt {
    private static final int ARRAY_COPY_THRESHOLD = 20;

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return new HashMap(map);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have same length as " + values);
        }
        Map<K, V> map = ContainerUtilRt.newHashMap(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<K, ? extends V> first, Pair<K, ? extends V> ... entries) {
        Map<K, V> map = ContainerUtilRt.newHashMap(entries.length + 1);
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(@NotNull Map<K, V> map) {
        return new TreeMap<K, V>(map);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        return new LinkedHashMap(capacity);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<K, V> map) {
        return new LinkedHashMap(map);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<K, V> first, @NotNull Pair<K, V>[] entries) {
        java.util.LinkedHashMap<K, V> map = ContainerUtilRt.newLinkedHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> entry : entries) {
            map.put(entry.getFirst(), entry.getSecond());
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        LinkedList<T> list = ContainerUtilRt.newLinkedList();
        Collections.addAll(list, elements);
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedList(), elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        ArrayList<T> list = ContainerUtilRt.newArrayListWithCapacity(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new ArrayList(collection);
        }
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        for (T element : elements) {
            collection.add(element);
        }
        return collection;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet() {
        return new HashSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new HashSet(collection);
        }
        return ContainerUtilRt.newHashSet(elements.iterator());
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        java.util.HashSet<T> set = ContainerUtilRt.newHashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return ContainerUtilRt.newLinkedHashSet(Arrays.asList(elements));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new LinkedHashSet(collection);
        }
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedHashSet(), elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        TreeSet<T> set = ContainerUtilRt.newTreeSet();
        Collections.addAll(set, elements);
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newTreeSet(), elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        return new Stack();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<T> elements) {
        return new Stack<T>(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        return new Stack<T>(Arrays.asList(initial));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtilRt.<T>emptyList());
    }

    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<T, V> mapper) {
        return ContainerUtilRt.map2List(Arrays.asList(array), mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        return ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        java.util.HashSet<V> set = new java.util.HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        return set;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        int length = array.length;
        if (length < 20 && array.length >= collection.size()) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            return array;
        }
        return collection.toArray(array);
    }

    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            return sample;
        }
        return c.toArray(sample);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a.length != 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return EmptyIterator.getInstance();
        }
    }
}

