/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentWeakValueHashMap(@NotNull Map<K, V> map) {
        super(map);
    }

    public ConcurrentWeakValueHashMap() {
    }

    public ConcurrentWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull K key, @NotNull V value) {
        return new MyWeakReference(key, value, this.myQueue);
    }

    private static class MyWeakReference<K, V>
    extends WeakReference<V>
    implements ConcurrentRefValueHashMap.ValueReference<K, V> {
        private final K key;

        private MyWeakReference(@NotNull K key, @NotNull V referent, @NotNull ReferenceQueue<V> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            return this.key;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            Object v = this.get();
            Object thatV = that.get();
            return this.key.equals(that.getKey()) && v != null && thatV != null && v.equals(thatV);
        }
    }
}

