/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Futures {
    @NotNull
    public static <V> Collection<Result<V>> invokeAll(@NotNull Collection<? extends Future<? extends V>> futures) {
        ArrayList<Result<V>> results = ContainerUtil.newArrayListWithCapacity(futures.size());
        try {
            for (Future<V> future : futures) {
                try {
                    results.add(new Result(future.get(), null));
                }
                catch (ExecutionException e) {
                    results.add(new Result(null, e));
                }
            }
        }
        catch (InterruptedException e) {
            Logger.getInstance(Futures.class).error(e);
            Thread.currentThread().interrupt();
        }
        return results;
    }

    private Futures() {
    }

    public static class Result<V> {
        private final V myResult;
        private final Throwable myError;

        private Result(V result, @Nullable Throwable error) {
            this.myResult = result;
            this.myError = error;
        }

        public boolean isOK() {
            return this.myError == null;
        }

        public V get() throws IllegalStateException {
            if (this.myError != null) {
                throw new IllegalStateException(this.myError);
            }
            return this.myResult;
        }

        @Nullable
        public Throwable getError() {
            return this.myError;
        }
    }
}

