/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class BoundedScheduledExecutorService
extends SchedulingWrapper {
    BoundedScheduledExecutorService(@NotNull ExecutorService backendExecutor, int maxSimultaneousTasks) {
        super(new BoundedTaskExecutor(backendExecutor, maxSimultaneousTasks), ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).delayQueue);
        assert (!(backendExecutor instanceof ScheduledExecutorService)) : "backendExecutor is already ScheduledExecutorService: " + backendExecutor;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.backendExecutorService.shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return ContainerUtil.concat(super.shutdownNow(), this.backendExecutorService.shutdownNow());
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown() && this.backendExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated() && this.backendExecutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return super.awaitTermination(timeout, unit) && this.backendExecutorService.awaitTermination(timeout, unit);
    }
}

