/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PatternUtil");
    public static final Pattern NOTHING = Pattern.compile("(a\\A)");
    private static final Map<String, String> ourEscapeRules = ContainerUtil.newLinkedHashMap();

    @NotNull
    public static String convertToRegex(@NotNull String mask) {
        List<String> strings = StringUtil.split(mask, "\\");
        StringBuilder pattern = new StringBuilder();
        String separator = "";
        for (String string : strings) {
            string = StringUtil.replace(string, ".", "\\.");
            for (Map.Entry<String, String> e : ourEscapeRules.entrySet()) {
                string = StringUtil.replace(string, e.getKey(), e.getValue());
            }
            pattern.append(separator);
            separator = "\\\\";
            pattern.append(string);
        }
        return pattern.toString();
    }

    @NotNull
    public static Pattern fromMask(@NotNull String mask) {
        try {
            return Pattern.compile(PatternUtil.convertToRegex(mask));
        }
        catch (PatternSyntaxException e) {
            LOG.error(mask, e);
            return NOTHING;
        }
    }

    @Contract(value="_, !null->!null")
    public static Pattern compileSafe(String pattern, Pattern def) {
        try {
            return Pattern.compile(pattern);
        }
        catch (Exception e) {
            return def;
        }
    }

    @Nullable
    public static String getFirstMatch(List<String> lines, Pattern regex) {
        if (lines == null) {
            return null;
        }
        for (String s : lines) {
            Matcher m = regex.matcher(s);
            if (!m.matches() || m.groupCount() <= 0) continue;
            return m.group(1);
        }
        return null;
    }

    static {
        ourEscapeRules.put("*", ".*");
        ourEscapeRules.put("?", ".");
        for (char c : "+()[]/^${}|".toCharArray()) {
            ourEscapeRules.put(String.valueOf(c), "\\" + c);
        }
    }
}

