/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.Convertor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = new Object();

    private ObjectUtils() {
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        return ObjectUtils.notNull(t);
    }

    public static <T> void assertAllElementsNotNull(@NotNull T[] array) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i + "] is null");
        }
    }

    @Contract(value="null, null -> null")
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="null,null->null")
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return t1 != null ? t1 : t2;
    }

    @Contract(value="null,null,null->null")
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2, @Nullable T t3) {
        return t1 != null ? t1 : (t2 != null ? t2 : t3);
    }

    @Nullable
    public static <T> T coalesce(@Nullable Iterable<T> o) {
        if (o == null) {
            return null;
        }
        for (T t : o) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value) {
        return ObjectUtils.notNull(value, value);
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        return value == null ? defaultValue : value;
    }

    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Nullable
    public static <T, S> S doIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Convertor<T, S> convertor) {
        if (clazz.isInstance(obj)) {
            return convertor.convert(obj);
        }
        return null;
    }

    @Nullable
    public static <T> T nullizeByCondition(@Nullable T obj, @NotNull Condition<T> condition) {
        if (condition.value(obj)) {
            return null;
        }
        return obj;
    }
}

