/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LineSeparator {
    LF("\n"),
    CRLF("\r\n"),
    CR("\r");

    private static final Logger LOG;
    private final String mySeparatorString;
    private final byte[] myBytes;

    private LineSeparator(String separatorString) {
        this.mySeparatorString = separatorString;
        this.myBytes = separatorString.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @NotNull
    public static LineSeparator fromString(@NotNull String string) {
        for (LineSeparator separator : LineSeparator.values()) {
            if (!separator.getSeparatorString().equals(string)) continue;
            return separator;
        }
        LOG.error("Invalid string for line separator: " + StringUtil.escapeStringCharacters(string));
        return LineSeparator.getSystemLineSeparator();
    }

    @NotNull
    public String getSeparatorString() {
        return this.mySeparatorString;
    }

    @NotNull
    public byte[] getSeparatorBytes() {
        return this.myBytes;
    }

    public static boolean knownAndDifferent(@Nullable LineSeparator separator1, @Nullable LineSeparator separator2) {
        return separator1 != null && separator2 != null && !separator1.equals((Object)separator2);
    }

    @NotNull
    public static LineSeparator getSystemLineSeparator() {
        if (SystemInfo.isWindows) {
            return CRLF;
        }
        return LF;
    }

    static {
        LOG = Logger.getInstance(LineSeparator.class);
    }
}

