/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static <T> T findCause(Throwable e, Class<T> klass) {
        while (e != null && !klass.isInstance(e)) {
            e = e.getCause();
        }
        Throwable t = e;
        return (T)t;
    }

    public static boolean causedBy(Throwable e, Class klass) {
        return ExceptionUtil.findCause(e, klass) != null;
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.asList(trace).subList(0, newDepth).toArray(new StackTraceElement[newDepth]));
            break;
        }
        return th;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        aThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        String prefix = "\tat ";
        String prefixProxy = "\tat $Proxy";
        String prefixRemoteUtil = "\tat com.intellij.execution.rmi.RemoteUtil";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            private boolean skipping;

            @Override
            public void println(String x) {
                boolean curSkipping = this.skipping;
                if (x != null) {
                    if (!this.skipping && x.startsWith(skipPattern)) {
                        curSkipping = true;
                    } else if (this.skipping && !x.startsWith("\tat ")) {
                        curSkipping = false;
                    }
                    if (curSkipping && !this.skipping) {
                        super.println("\tin " + ExceptionUtil.stripPackage(x, skipPattern.length()));
                    }
                    this.skipping = curSkipping;
                    if (this.skipping) {
                        this.skipping = !x.startsWith("\tat com.intellij.execution.rmi.RemoteUtil");
                        return;
                    }
                    if (x.startsWith("\tat $Proxy")) {
                        return;
                    }
                    super.println(x);
                }
            }
        };
        aThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    private static String stripPackage(String x, int offset) {
        int idx = offset;
        while (idx > 0 && idx < x.length() && !Character.isUpperCase(x.charAt(idx))) {
            idx = x.indexOf(46, idx) + 1;
        }
        return x.substring(Math.max(idx, offset));
    }

    @NotNull
    public static String getUserStackTrace(@NotNull Throwable aThrowable, Logger logger) {
        String result = ExceptionUtil.getThrowableText(aThrowable, "com.intellij.");
        if (!result.contains("\n\tat")) {
            logger.error(aThrowable);
        }
        return result;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while ((result == null || result.contains(exceptionPattern) || result.contains(errorPattern)) && e.getCause() != null) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = ExceptionUtil.extractMessage(result, exceptionPattern);
            result = ExceptionUtil.extractMessage(result, errorPattern);
        }
        return result;
    }

    @NotNull
    private static String extractMessage(@NotNull String result, @NotNull String errorPattern) {
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        return result;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) {
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
    }

    public static void rethrowAll(@Nullable Throwable t) throws Exception {
        if (t != null) {
            ExceptionUtil.rethrowUnchecked(t);
            throw (Exception)t;
        }
    }

    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtil.rethrowUnchecked(t);
            throw new RuntimeException(t);
        }
    }

    @NotNull
    public static String getNonEmptyMessage(@NotNull Throwable t, @NotNull String defaultMessage) {
        String message = t.getMessage();
        return !StringUtil.isEmptyOrSpaces(message) ? message : defaultMessage;
    }
}

